/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.inputDevice;

import java.awt.geom.Point2D;
import kinugasa.inputDevice.GamePadButtons;
import kinugasa.inputDevice.InputDeviceState;

public class GamePadState
extends InputDeviceState {
    private static final long serialVersionUID = -3599701264472336389L;
    private boolean connection;
    public Buttons buttons;
    public ThumbStick leftStick;
    public ThumbStick rightStick;
    public Trigger leftTrigger;
    public Trigger rightTrigger;
    private static float thumbStickDeadZone = 0.18921477f;
    private static float triggerDeadZone = 0.0f;

    GamePadState(float[] values) {
        this.buttons = new Buttons(values);
        this.leftTrigger = new Trigger(values[14]);
        this.rightTrigger = new Trigger(values[15]);
        this.leftStick = new ThumbStick(values[16], values[17]);
        this.rightStick = new ThumbStick(values[18], values[19]);
        this.connection = values[20] != 0.0f;
    }

    public boolean isConnected() {
        return this.connection;
    }

    @Override
    public boolean isAnyInput() {
        return this.buttons.isAnyInput() || this.leftStick.isAnyInput() || this.rightStick.isAnyInput() || this.leftTrigger.isAnyInput() || this.rightTrigger.isAnyInput();
    }

    @Override
    public boolean isAnyButtonInput() {
        return this.buttons.isAnyButtonInput() || this.leftStick.isAnyButtonInput() || this.rightStick.isAnyButtonInput() || this.leftTrigger.isAnyButtonInput() || this.rightTrigger.isAnyButtonInput();
    }

    @Override
    public boolean isEmptyInput() {
        return this.buttons.isEmptyInput() && this.leftStick.isEmptyInput() && this.rightStick.isEmptyInput() && this.leftTrigger.isEmptyInput() && this.rightTrigger.isEmptyInput();
    }

    public static float getThumbStickDeadZone() {
        return thumbStickDeadZone;
    }

    public static void setThumbStickDeadZone(float thumbStickDeadZone) {
        GamePadState.thumbStickDeadZone = thumbStickDeadZone;
    }

    public static void setTriggerDeadZone(float triggerDeadZone) {
        GamePadState.triggerDeadZone = triggerDeadZone;
    }

    public static float getTriggerDeadZone() {
        return triggerDeadZone;
    }

    public String toString() {
        return "GamePadState{connection:{" + this.connection + "}, buttons:{" + this.buttons + "}, leftStick:{" + this.leftStick + "}, rightStick:{" + this.rightStick + "}, leftTrigger:{" + this.leftTrigger + "}, rightTrigger:{" + this.rightTrigger + "}}";
    }

    @Override
    public GamePadState clone() {
        GamePadState result = (GamePadState)super.clone();
        result.buttons = this.buttons.clone();
        result.leftTrigger = this.leftTrigger.clone();
        result.rightTrigger = this.rightTrigger.clone();
        result.leftStick = this.leftStick.clone();
        result.rightStick = this.rightStick.clone();
        return result;
    }

    public final class ThumbStick
    extends InputDeviceState {
        private static final long serialVersionUID = 1L;
        private Point2D.Float value;

        private ThumbStick(float x, float y) {
            this.value = new Point2D.Float(Math.abs(x) < thumbStickDeadZone ? 0.0f : x, Math.abs(y) < thumbStickDeadZone ? 0.0f : y);
        }

        public Point2D.Float getValue() {
            return (Point2D.Float)this.value.clone();
        }

        public float getX() {
            return this.value.x;
        }

        public float getY() {
            return this.value.y;
        }

        public String toString() {
            return "x=" + this.value.x + ", y=" + this.value.y;
        }

        @Override
        public ThumbStick clone() {
            ThumbStick result = (ThumbStick)super.clone();
            result.value = (Point2D.Float)this.value.clone();
            return result;
        }

        @Override
        public boolean isAnyInput() {
            return this.getX() != 0.0f || this.getY() != 0.0f;
        }

        @Override
        public boolean isAnyButtonInput() {
            return this.getX() != 0.0f || this.getY() != 0.0f;
        }

        @Override
        public boolean isEmptyInput() {
            return this.getX() == 0.0f && this.getY() == 0.0f;
        }
    }

    public final class Trigger
    extends InputDeviceState {
        private static final long serialVersionUID = 1L;
        public final float VALUE;

        private Trigger(float value) {
            this.VALUE = value < triggerDeadZone ? 0.0f : value;
        }

        public String toString() {
            return Float.toString(this.VALUE);
        }

        @Override
        public Trigger clone() {
            return (Trigger)super.clone();
        }

        @Override
        public boolean isAnyInput() {
            return this.VALUE != 0.0f;
        }

        @Override
        public boolean isAnyButtonInput() {
            return this.VALUE != 0.0f;
        }

        @Override
        public boolean isEmptyInput() {
            return this.VALUE == 0.0f;
        }
    }

    public final class Buttons
    extends InputDeviceState {
        private static final long serialVersionUID = 1L;
        public final boolean A;
        public final boolean B;
        public final boolean X;
        public final boolean Y;
        public final boolean LEFT_SHOULDER;
        public final boolean RIGHT_SHOULDER;
        public final boolean LEFT_STICK;
        public final boolean RIGHT_STICK;
        public final boolean PAD_UP;
        public final boolean PAD_DOWN;
        public final boolean PAD_LEFT;
        public final boolean PAD_RIGHT;
        public final boolean START;
        public final boolean BACK;

        private Buttons(float[] data) {
            this.A = data[0] != 0.0f;
            this.B = data[1] != 0.0f;
            this.X = data[2] != 0.0f;
            this.Y = data[3] != 0.0f;
            this.LEFT_SHOULDER = data[4] != 0.0f;
            this.RIGHT_SHOULDER = data[5] != 0.0f;
            this.LEFT_STICK = data[6] != 0.0f;
            this.RIGHT_STICK = data[7] != 0.0f;
            this.PAD_UP = data[8] != 0.0f;
            this.PAD_DOWN = data[9] != 0.0f;
            this.PAD_LEFT = data[10] != 0.0f;
            this.PAD_RIGHT = data[11] != 0.0f;
            this.START = data[12] != 0.0f;
            this.BACK = data[13] != 0.0f;
        }

        public boolean isPressed(GamePadButtons b) {
            return this.isPressed(b.getValue());
        }

        public boolean isPressed(int field) {
            switch (field) {
                case 0: {
                    return this.A;
                }
                case 1: {
                    return this.B;
                }
                case 2: {
                    return this.X;
                }
                case 3: {
                    return this.Y;
                }
                case 4: {
                    return this.LEFT_SHOULDER;
                }
                case 5: {
                    return this.RIGHT_SHOULDER;
                }
                case 6: {
                    return this.LEFT_STICK;
                }
                case 7: {
                    return this.RIGHT_STICK;
                }
                case 8: {
                    return this.PAD_UP;
                }
                case 9: {
                    return this.PAD_DOWN;
                }
                case 10: {
                    return this.PAD_LEFT;
                }
                case 11: {
                    return this.PAD_RIGHT;
                }
                case 12: {
                    return this.START;
                }
                case 13: {
                    return this.BACK;
                }
            }
            return false;
        }

        public String toString() {
            return "A=" + this.A + ", B=" + this.B + ", X=" + this.X + ", Y=" + this.Y + ", LEFT_SHOULDER=" + this.LEFT_SHOULDER + ", RIGHT_SHOULDER=" + this.RIGHT_SHOULDER + ", LEFT_STICK=" + this.LEFT_STICK + ", RIGHT_STICK=" + this.RIGHT_STICK + ", PAD_UP=" + this.PAD_UP + ", PAD_DOWN=" + this.PAD_DOWN + ", PAD_LEFT=" + this.PAD_LEFT + ", PAD_RIGHT=" + this.PAD_RIGHT + ", START=" + this.START + ", BACK=" + this.BACK;
        }

        @Override
        public Buttons clone() {
            return (Buttons)super.clone();
        }

        @Override
        public boolean isAnyInput() {
            return this.A || this.B || this.BACK || this.LEFT_SHOULDER || this.LEFT_STICK || this.PAD_DOWN || this.PAD_LEFT || this.PAD_RIGHT || this.PAD_UP || this.RIGHT_SHOULDER || this.RIGHT_STICK || this.START || this.X || this.Y;
        }

        @Override
        public boolean isAnyButtonInput() {
            return this.A || this.B || this.BACK || this.LEFT_SHOULDER || this.LEFT_STICK || this.PAD_DOWN || this.PAD_LEFT || this.PAD_RIGHT || this.PAD_UP || this.RIGHT_SHOULDER || this.RIGHT_STICK || this.START || this.X || this.Y;
        }

        @Override
        public boolean isEmptyInput() {
            return this.A && !this.B && !this.BACK && !this.LEFT_SHOULDER && !this.LEFT_STICK && !this.PAD_DOWN && !this.PAD_LEFT && !this.PAD_RIGHT && !this.PAD_UP && !this.RIGHT_SHOULDER && !this.RIGHT_STICK && !this.START && !this.X && !this.Y;
        }
    }
}

