/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.inputDevice;

import kinugasa.game.PlayerConstants;
import kinugasa.inputDevice.GamePadButtons;
import kinugasa.inputDevice.GamePadConnection;
import kinugasa.inputDevice.GamePadState;
import kinugasa.inputDevice.InputDeviceState;
import kinugasa.inputDevice.InputType;
import kinugasa.inputDevice.KeyConnection;
import kinugasa.inputDevice.KeyState;
import kinugasa.inputDevice.Keys;
import kinugasa.inputDevice.MouseButtons;
import kinugasa.inputDevice.MouseConnection;
import kinugasa.inputDevice.MouseState;
import kinugasa.object.FourDirection;

public final class InputState
extends InputDeviceState {
    private static final long serialVersionUID = 2349722781837661059L;
    private GamePadState gamePadState = null;
    private GamePadState prevGamePadState = null;
    private KeyState keyState = null;
    private KeyState prevKeyState = null;
    private MouseState mouseState = null;
    private MouseState prevMouseState = null;
    private static final InputState INSTANCE = new InputState();

    private InputState() {
        if (PlayerConstants.getInstance().isUsingGamepad()) {
            this.gamePadState = GamePadConnection.createClearState();
        }
        if (PlayerConstants.getInstance().isUsingKeyboard()) {
            this.keyState = KeyConnection.createClearState();
        }
        if (PlayerConstants.getInstance().isUsingMouse()) {
            this.mouseState = MouseConnection.createClearState();
        }
    }

    public static InputState getInstance() {
        INSTANCE.refresh();
        return INSTANCE;
    }

    private void refresh() {
        if (PlayerConstants.getInstance().isUsingGamepad()) {
            this.prevGamePadState = this.gamePadState;
            this.gamePadState = GamePadConnection.getState(0);
        }
        if (PlayerConstants.getInstance().isUsingMouse()) {
            this.prevMouseState = this.mouseState;
            this.mouseState = MouseConnection.getState();
        }
        if (PlayerConstants.getInstance().isUsingKeyboard()) {
            this.prevKeyState = this.keyState;
            this.keyState = KeyConnection.getState();
        }
    }

    @Override
    public boolean isAnyInput() {
        boolean result = false;
        if (PlayerConstants.getInstance().isUsingGamepad()) {
            result |= this.gamePadState.isAnyInput();
        }
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result |= this.mouseState.isAnyInput();
        }
        return result | this.keyState.isAnyInput();
    }

    @Override
    public boolean isAnyButtonInput() {
        boolean result = false;
        if (PlayerConstants.getInstance().isUsingGamepad()) {
            result |= this.gamePadState.isAnyButtonInput();
        }
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result |= this.mouseState.isAnyButtonInput();
        }
        return result | this.keyState.isAnyButtonInput();
    }

    @Override
    public boolean isEmptyInput() {
        boolean result = true;
        if (PlayerConstants.getInstance().isUsingGamepad()) {
            result &= this.gamePadState.isEmptyInput();
        }
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result &= this.mouseState.isEmptyInput();
        }
        return result & this.keyState.isEmptyInput();
    }

    public boolean isPressed(Keys key, InputType type) {
        return type == InputType.CONTINUE ? this.keyState.isPressed(key) : this.keyState.isPressed(key) && !this.prevKeyState.isPressed(key);
    }

    public boolean isPressed(GamePadButtons button, InputType type) {
        return type == InputType.CONTINUE ? this.gamePadState.buttons.isPressed(button) : this.gamePadState.buttons.isPressed(button) && !this.prevGamePadState.buttons.isPressed(button);
    }

    public boolean isPressed(MouseButtons button, InputType type) {
        if (!PlayerConstants.getInstance().isUsingMouse()) {
            return false;
        }
        return type == InputType.CONTINUE ? this.mouseState.isPressed(button) : this.mouseState.isPressed(button) && !this.prevMouseState.isPressed(button);
    }

    public boolean leftStickOperation(float absBorderLine, FourDirection dir, InputType type) {
        switch (dir) {
            case EAST: {
                switch (type) {
                    case SINGLE: {
                        return this.gamePadState.leftStick.getX() < -Math.abs(absBorderLine) && this.prevGamePadState.leftStick.getX() >= -Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.leftStick.getX() < -Math.abs(absBorderLine) && this.gamePadState.leftStick.getX() < 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
            case WEST: {
                switch (type) {
                    case SINGLE: {
                        return Math.abs(this.gamePadState.leftStick.getX()) > Math.abs(absBorderLine) && this.prevGamePadState.leftStick.getX() <= Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.leftStick.getX() > Math.abs(absBorderLine) && this.gamePadState.leftStick.getX() > 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
            case NORTH: {
                switch (type) {
                    case SINGLE: {
                        return this.gamePadState.leftStick.getY() > Math.abs(absBorderLine) && this.prevGamePadState.leftStick.getY() <= Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.leftStick.getY() > Math.abs(absBorderLine) && this.gamePadState.leftStick.getY() > 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
            case SOUTH: {
                switch (type) {
                    case SINGLE: {
                        return this.gamePadState.leftStick.getY() < -Math.abs(absBorderLine) && this.prevGamePadState.leftStick.getY() >= -Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.leftStick.getY() < -Math.abs(absBorderLine) && this.gamePadState.leftStick.getY() < 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
        }
        throw new AssertionError((Object)("unuse default : dir=[" + (Object)((Object)dir) + "]"));
    }

    public boolean rightStickOperation(float absBorderLine, FourDirection dir, InputType type) {
        switch (dir) {
            case EAST: {
                switch (type) {
                    case SINGLE: {
                        return this.gamePadState.rightStick.getX() < -Math.abs(absBorderLine) && this.prevGamePadState.rightStick.getX() >= -Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.rightStick.getX() < -Math.abs(absBorderLine) && this.gamePadState.rightStick.getX() < 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
            case WEST: {
                switch (type) {
                    case SINGLE: {
                        return this.gamePadState.rightStick.getX() > Math.abs(absBorderLine) && this.prevGamePadState.rightStick.getX() <= Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.rightStick.getX() > Math.abs(absBorderLine) && this.gamePadState.rightStick.getX() > 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
            case NORTH: {
                switch (type) {
                    case SINGLE: {
                        return this.gamePadState.rightStick.getY() > Math.abs(absBorderLine) && this.prevGamePadState.rightStick.getY() <= Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.rightStick.getY() > Math.abs(absBorderLine) && this.gamePadState.rightStick.getY() > 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
            case SOUTH: {
                switch (type) {
                    case SINGLE: {
                        return this.gamePadState.rightStick.getY() < -Math.abs(absBorderLine) && this.prevGamePadState.rightStick.getY() >= -Math.abs(absBorderLine);
                    }
                    case CONTINUE: {
                        return this.gamePadState.rightStick.getY() < -Math.abs(absBorderLine) && this.gamePadState.rightStick.getY() > 0.0f;
                    }
                }
                throw new AssertionError((Object)("unuse default : type=[" + (Object)((Object)type) + "]"));
            }
        }
        throw new AssertionError((Object)("! > InputState rightStickOperation : unuse default : dir=[" + (Object)((Object)dir) + "]"));
    }

    public GamePadState getGamePadState() {
        return this.gamePadState;
    }

    public GamePadState getPrevGamePadState() {
        return this.prevGamePadState;
    }

    public KeyState getKeyState() {
        return this.keyState;
    }

    public KeyState getPrevKeyState() {
        return this.prevKeyState;
    }

    public MouseState getPrevMouseState() {
        return this.prevMouseState;
    }

    public MouseState getMouseState() {
        return this.mouseState;
    }

    @Override
    public InputState clone() {
        InputState result = (InputState)super.clone();
        if (this.gamePadState != null) {
            result.gamePadState = this.gamePadState.clone();
        }
        if (this.prevGamePadState != null) {
            result.prevGamePadState = this.prevGamePadState.clone();
        }
        if (this.mouseState != null) {
            result.mouseState = this.mouseState.clone();
        }
        if (this.prevMouseState != null) {
            result.prevMouseState = this.prevMouseState.clone();
        }
        if (this.keyState != null) {
            result.keyState = this.keyState.clone();
        }
        if (this.prevKeyState != null) {
            result.prevKeyState = this.prevKeyState.clone();
        }
        return result;
    }

    public String toString() {
        return "InputState{gamePadState=" + this.gamePadState + ", keyState=" + this.keyState + ", mouseState=" + this.mouseState + '}';
    }
}

