/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.inputDevice;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import kinugasa.inputDevice.MouseState;

public class MouseConnection
extends MouseAdapter {
    private static final MouseConnection INSTANCE = new MouseConnection();
    private static final MouseState CLEAR_STATE = new MouseState(false, false, false, false, false, 0, new Point(), new Point());
    private boolean[] buttonState = new boolean[]{false, false, false};
    private boolean entry;
    private boolean drag;
    private Point location = new Point();
    private Point locationOnScreen = new Point();
    private int wheelValue;

    public static void setListener(Component component) {
        component.addMouseListener(INSTANCE);
        component.addMouseMotionListener(INSTANCE);
        component.addMouseWheelListener(INSTANCE);
    }

    public static MouseState createClearState() {
        return CLEAR_STATE;
    }

    private MouseConnection() {
    }

    public static MouseState getState() {
        return new MouseState(MouseConnection.INSTANCE.buttonState[0], MouseConnection.INSTANCE.buttonState[2], MouseConnection.INSTANCE.buttonState[1], MouseConnection.INSTANCE.entry, MouseConnection.INSTANCE.drag, MouseConnection.INSTANCE.wheelValue, MouseConnection.INSTANCE.location, MouseConnection.INSTANCE.locationOnScreen);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.drag = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.location = e.getPoint();
        this.locationOnScreen = e.getLocationOnScreen();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.buttonState[e.getButton() - 1] = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.buttonState[e.getButton() - 1] = false;
        this.drag = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.entry = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.entry = false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.wheelValue = e.getUnitsToScroll();
    }
}

