/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.io.Serializable;
import kinugasa.contents.resource.Nameable;
import kinugasa.ui.LabelModel;
import kinugasa.ui.TextLabel;

public final class CharSet
implements Nameable,
Serializable {
    private static final long serialVersionUID = -6702495690225290022L;
    private String name;
    private String values;
    private float drawSizeMag;

    public CharSet(String name, float charSize, String allData) throws IllegalArgumentException {
        if (allData.contains("\uff3f")) {
            throw new IllegalArgumentException("! > CharSet : ctor : cant use \"\uff3f\" : name=[" + name + "] bytes=[" + charSize + "] data=[" + allData + "]");
        }
        this.name = name;
        this.drawSizeMag = charSize;
        this.values = allData;
    }

    public boolean contains(String c) {
        return this.values.contains(c);
    }

    public boolean cotnains(char c) {
        return this.values.contains(Character.toString(c));
    }

    public float getDrawSizeMag() {
        return this.drawSizeMag;
    }

    public float convertSize(float fontSize) {
        return fontSize * this.drawSizeMag;
    }

    public String getValues() {
        return this.values;
    }

    public TextLabel[][] parse(float startX, float startY, LabelModel labelModel) {
        TextLabel[][] result = new TextLabel[this.rowNum()][];
        float charSize = labelModel.getFontSize() + 2.0f;
        String[] lines = this.values.split("\n");
        for (int yIdx = 0; yIdx < lines.length; ++yIdx) {
            char[] lineData = lines[yIdx].toCharArray();
            result[yIdx] = new TextLabel[lineData.length];
            for (int xIdx = 0; xIdx < lineData.length; ++xIdx) {
                result[yIdx][xIdx] = new TextLabel(startX + (float)xIdx * charSize, startY + (float)yIdx * charSize, Character.toString(lineData[xIdx]), labelModel);
            }
        }
        return result;
    }

    public int rowNum() {
        return this.values.split("\n").length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "CharSet{name=" + this.name + ", values=" + this.values + '}';
    }
}

