/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import kinugasa.object.Model;
import kinugasa.ui.TextLabel;
import kinugasa.util.TimeCounter;

public abstract class ChoiceEffect
extends Model {
    private static final long serialVersionUID = -3642532507764357135L;

    public abstract void draw(Graphics2D var1, TextLabel var2);

    @Override
    public ChoiceEffect clone() {
        return (ChoiceEffect)super.clone();
    }

    public static ChoiceEffect craeteSingleCharChoiceEffect(Color color) {
        return new SingleCharEffect(color);
    }

    public static ChoiceEffect craeteSingleCharChoiceEffect(Color color, TimeCounter blinkRate) {
        return new SingleCharEffect(color, blinkRate);
    }

    private static final class SingleCharEffect
    extends ChoiceEffect {
        private static final long serialVersionUID = -3270758183562208632L;
        private TimeCounter blinkTime;
        private Color color;

        SingleCharEffect(Color color) {
            this.color = color;
            this.blinkTime = TimeCounter.TRUE;
        }

        SingleCharEffect(Color color, TimeCounter blinkTime) {
            this.blinkTime = blinkTime;
            this.color = color;
        }

        @Override
        public void draw(Graphics2D g, TextLabel label) {
            if (!this.blinkTime.isReaching()) {
                return;
            }
            g.setColor(this.color);
            float x = label.getX() - 3.0f;
            float y = label.getY() + 3.0f;
            float w = label.getLabelModel().getFontSize() + 3.0f;
            float h = label.getLabelModel().getFontSize();
            g.fillRect((int)x, (int)y, (int)w, (int)h);
        }

        @Override
        public ChoiceEffect clone() {
            SingleCharEffect cf = (SingleCharEffect)super.clone();
            cf.blinkTime = this.blinkTime.clone();
            return cf;
        }
    }
}

