/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import kinugasa.ui.ChoiceEffect;
import kinugasa.ui.LabelModel;
import kinugasa.ui.MessageWindow;
import kinugasa.ui.MessageWindowModel;
import kinugasa.ui.SelectableMessageWindow;
import kinugasa.util.TimeCounter;

public class ConfirmMessageWindow
extends SelectableMessageWindow {
    private static final long serialVersionUID = -8448581906646818648L;
    private String yesMessage;
    private String noMessage;

    public ConfirmMessageWindow(float x, float y, float width, float height, MessageWindowModel wm, LabelModel lm, TimeCounter tc, String text, String yes, String no, ChoiceEffect ce) throws NullPointerException {
        super(x, y, width, height, wm, lm, tc, text + "\n" + "   " + yes + "\n" + "   " + no, 0, 0, 1, ce);
        this.yesMessage = yes;
        this.noMessage = no;
        String message = text + "\n" + "   " + yes + "\n" + "   " + no;
        String[] texts = message.split(MessageWindow.getSeparator());
        for (int i = 0; i < texts.length; ++i) {
            if (!texts[i].replaceAll(" ", "").equals(yes)) continue;
            this.setMinIndex(i);
            this.setMaxIndex(i + 1);
            this.select(i);
        }
    }

    public String getYesMessage() {
        return this.yesMessage;
    }

    public String getNoMessage() {
        return this.noMessage;
    }

    public boolean isYesOption() {
        return this.getSelectedLabel().getText().replaceAll(" ", "").equals(this.yesMessage);
    }

    @Override
    public ConfirmMessageWindow clone() {
        return (ConfirmMessageWindow)super.clone();
    }
}

