/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kinugasa.ui.CharSet;
import kinugasa.ui.ChoiceEffect;
import kinugasa.ui.LabelModel;
import kinugasa.ui.MessageWindow;
import kinugasa.ui.MessageWindowModel;
import kinugasa.ui.TextLabel;
import kinugasa.util.FrameTimeCounter;
import kinugasa.util.TimeCounter;

public class InputMessageWindow
extends MessageWindow {
    private static final long serialVersionUID = -3348163241388833782L;
    public static String COMMAND_OK = "\u6c7a\u5b9a";
    public static String COMMAND_CANCEL = "\u623b\u308b";
    private TextLabel[][] choiceLabels;
    private int maxLength;
    private LabelModel choicesLabelModel;
    private CharSet[] charSets;
    private ChoiceEffect choiceEffect;
    private int selectedIndexX;
    private int selectedIndexY;
    private TextLabel inputValueLabel;
    private int caretIndex;
    private TimeCounter caretBlinkRate;
    private float caretX;
    private float caretY;
    private Color caretColor = new Color(255, 255, 255, 128);
    private TextLabel[] commandLabels;

    public InputMessageWindow(float x, float y, float width, float height, MessageWindowModel windowModel, LabelModel messageLabelModel, LabelModel choicesLabelModel, String message, ChoiceEffect choiceEffect, int maxLength, boolean useCommandLabels, CharSet ... charSet) throws IllegalArgumentException, NullPointerException {
        super(x, y, width, height, windowModel, messageLabelModel, message);
        if (charSet == null) {
            throw new NullPointerException("! > InputMessageWindow : ctor : charSet is null : message=[" + message + "]");
        }
        if (message == null) {
            throw new NullPointerException("! > InputMessageWindow : ctor : message is null : message=[" + message + "]");
        }
        if (charSet.length == 0) {
            throw new IllegalArgumentException("! > InputMessageWindow : ctor : charSet.length == 0 : message=[" + message + "]");
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("! > InputMessageWindow : ctor maxLength <= 0 : maxLength=[" + maxLength + "]");
        }
        this.choiceEffect = choiceEffect;
        this.selectedIndexY = 0;
        this.selectedIndexX = 0;
        this.caretIndex = 0;
        this.choicesLabelModel = choicesLabelModel;
        this.maxLength = maxLength;
        this.charSets = charSet;
        this.caretBlinkRate = new FrameTimeCounter(20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        this.initLabels(useCommandLabels);
        this.caretY = this.inputValueLabel.getY();
        this.caretX = this.inputValueLabel.getX();
    }

    private void initLabels(boolean useCommand) {
        float charSize = this.choicesLabelModel.getFontSize() + 2.0f;
        float x = this.labels[this.labels.length - 1].getX() + 8.0f;
        float y = this.labels[this.labels.length - 1].getY() + charSize * 2.0f;
        String defaultText = "";
        for (int i = 0; i < this.maxLength; ++i) {
            defaultText = defaultText + "\uff3f";
        }
        this.inputValueLabel = new TextLabel(x, y, defaultText, this.labels[0].getLabelModel());
        y += charSize * 2.0f;
        ArrayList<TextLabel[]> csChoiceLabels = new ArrayList<TextLabel[]>(512);
        int maxWidth = 0;
        for (CharSet cs : this.charSets) {
            for (TextLabel[] l : cs.parse(x, y, this.choicesLabelModel)) {
                csChoiceLabels.add(l);
                if (maxWidth >= l.length) continue;
                maxWidth = l.length;
            }
            y += charSize * (float)cs.rowNum() + charSize;
        }
        this.choiceLabels = new TextLabel[csChoiceLabels.size() + (useCommand ? 1 : 0)][];
        int size = csChoiceLabels.size();
        for (int i = 0; i < size; ++i) {
            TextLabel[] line = (TextLabel[])csChoiceLabels.get(i);
            this.choiceLabels[i] = new TextLabel[line.length];
            System.arraycopy(line, 0, this.choiceLabels[i], 0, line.length);
        }
        if (useCommand) {
            this.initCommandLabels();
        }
    }

    private void initCommandLabels() {
        this.choiceLabels[this.choiceLabels.length - 1] = new TextLabel[2];
        TextLabel mostUnder = this.choiceLabels[this.choiceLabels.length - 2][0];
        assert (mostUnder != null) : "[\u5148\u5929]\u3042\u306a\u305f\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u9593\u9055\u3063\u3066\u3044\u308b mostUnder == null";
        float x = mostUnder.getX();
        float y = mostUnder.getY();
        this.commandLabels = new TextLabel[]{new TextLabel(x, y += mostUnder.getLabelModel().getFontSize() + 2.0f, COMMAND_OK, this.choicesLabelModel), new TextLabel(x + this.choicesLabelModel.getFontSize() * 2.0f + 12.0f, y, COMMAND_CANCEL, this.choicesLabelModel)};
        System.arraycopy(this.commandLabels, 0, this.choiceLabels[this.choiceLabels.length - 1], 0, this.commandLabels.length);
    }

    private CharSet searchCharSet(char c) throws AssertionError {
        for (CharSet cs : this.charSets) {
            if (!cs.contains(Character.toString(c))) continue;
            return cs;
        }
        throw new AssertionError((Object)("! > InputMessageWindow : character not found :" + c));
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        this.inputValueLabel.draw(g);
        TextLabel[][] arr$ = this.choiceLabels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TextLabel[] textLabelArray;
            for (TextLabel label : textLabelArray = arr$[i$]) {
                label.draw(g);
            }
        }
        if (this.choiceEffect != null) {
            this.choiceEffect.draw(g, this.getSelectedLabel());
        }
        if (this.caretBlinkRate.isReaching() && !this.isMaxInput()) {
            this.drawCaret(g);
        }
        if (this.commandLabels != null) {
            for (TextLabel[] textLabelArray : this.commandLabels) {
                textLabelArray.draw(g);
            }
        }
    }

    private void drawCaret(Graphics2D g) {
        g.setColor(this.caretColor);
        float size = this.inputValueLabel.getLabelModel().getFontSize();
        g.fillRect((int)this.caretX, (int)this.caretY, (int)size / 2, (int)size);
    }

    public boolean isCommandSelect() {
        return this.isOkSelected() | this.isCancelSelected();
    }

    public boolean isOkSelected() {
        if (this.commandLabels == null) {
            return false;
        }
        for (TextLabel label : this.commandLabels) {
            if (!this.getSelectedLabel().equals(label) || !label.getText().equals(COMMAND_OK)) continue;
            return true;
        }
        return false;
    }

    public boolean isCancelSelected() {
        for (TextLabel label : this.commandLabels) {
            if (!this.getSelectedLabel().equals(label) || !label.getText().equals(COMMAND_CANCEL)) continue;
            return true;
        }
        return false;
    }

    public String enter() {
        if (this.isCommandSelect()) {
            return this.getSelectedLabel().getText();
        }
        if (this.isMaxInput()) {
            return this.inputValueLabel.getText().replaceAll("\uff3f", "");
        }
        char[] inputData = this.inputValueLabel.getText().toCharArray();
        inputData[this.caretIndex] = this.getSelectedLabel().getText().charAt(0);
        this.caretX += this.searchCharSet(inputData[this.caretIndex]).convertSize(this.inputValueLabel.getLabelModel().getFontSize());
        if (this.inputValueLabel.getLabelModel().getFont().isBold()) {
            this.caretX += 1.0f;
        }
        this.inputValueLabel.setText(String.valueOf(inputData));
        ++this.caretIndex;
        return this.inputValueLabel.getText().replaceAll("\uff3f", "");
    }

    public void backSpace() {
        if (this.isNotYetInput()) {
            return;
        }
        --this.caretIndex;
        char[] inputData = this.inputValueLabel.getText().toCharArray();
        this.caretX -= this.searchCharSet(inputData[this.caretIndex]).convertSize(this.inputValueLabel.getLabelModel().getFontSize());
        if (this.inputValueLabel.getLabelModel().getFont().isBold()) {
            this.caretX -= 1.0f;
        }
        inputData[this.caretIndex] = 65343;
        this.inputValueLabel.setText(String.valueOf(inputData));
    }

    public String ok() {
        this.setExist(false);
        this.setVisible(false);
        return this.getInputText();
    }

    public void cancel() {
        String text = "";
        for (int i = 0; i < this.maxLength; ++i) {
            text = text + "\uff3f";
        }
        this.inputValueLabel.setText(text);
        this.setExist(false);
        this.setVisible(false);
    }

    public boolean isMaxInput() {
        return this.caretIndex == this.maxLength;
    }

    public boolean isNotYetInput() {
        return this.caretIndex == 0;
    }

    public void toLeft() {
        --this.selectedIndexX;
        this.clamp();
    }

    public void toRight() {
        ++this.selectedIndexX;
        this.clamp();
    }

    public void toDown() {
        ++this.selectedIndexY;
        this.clamp();
    }

    public void toUp() {
        --this.selectedIndexY;
        this.clamp();
    }

    private void clamp() {
        if (this.selectedIndexY < 0) {
            this.selectedIndexY = 0;
        } else if (this.selectedIndexY > this.choiceLabels.length - 1) {
            this.selectedIndexY = this.choiceLabels.length - 1;
        }
        if (this.selectedIndexX < 0) {
            this.selectedIndexX = 0;
        } else if (this.selectedIndexX > this.choiceLabels[this.selectedIndexY].length - 1) {
            this.selectedIndexX = this.choiceLabels[this.selectedIndexY].length - 1;
        }
    }

    public void setCaretBlinkRate(TimeCounter cursorBlink) {
        this.caretBlinkRate = cursorBlink;
    }

    public TimeCounter getCaretBlinkRate() {
        return this.caretBlinkRate;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public TextLabel getSelectedLabel() {
        return this.choiceLabels[this.selectedIndexY][this.selectedIndexX].clone();
    }

    public String getSelectedLabelText() {
        return this.getSelectedLabel().getText();
    }

    public int getSelectedIndexX() {
        return this.selectedIndexX;
    }

    public void setSelectedIndexX(int selectedIndexX) {
        this.selectedIndexX = selectedIndexX;
    }

    public int getSelectedIndexY() {
        return this.selectedIndexY;
    }

    public void setSelectedIndexY(int selectedIndexY) {
        this.selectedIndexY = selectedIndexY;
    }

    public CharSet[] getCharSets() {
        return this.charSets;
    }

    public List<TextLabel> getChoiceLabelsList() {
        ArrayList<TextLabel> result = new ArrayList<TextLabel>();
        for (TextLabel[] line : this.choiceLabels) {
            result.addAll(Arrays.asList(line));
        }
        return result;
    }

    public TextLabel[][] getChoiceLabels() {
        return this.choiceLabels;
    }

    public LabelModel getChoicesLabelModel() {
        return this.choicesLabelModel;
    }

    public ChoiceEffect getChoiceEffect() {
        return this.choiceEffect;
    }

    public void setChoiceEffect(ChoiceEffect choiceEffect) {
        this.choiceEffect = choiceEffect;
    }

    public TextLabel getInputValueLabel() {
        return this.inputValueLabel.clone();
    }

    public String getInputText() {
        return this.inputValueLabel.getText().replaceAll("\uff3f", "");
    }

    public void printAll(PrintStream stream) {
        System.out.println("> InputMessageWindow : printAll : ");
        TextLabel[][] arr$ = this.choiceLabels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TextLabel[] l;
            for (TextLabel t : l = arr$[i$]) {
                System.out.print(t.getText() + ", ");
            }
            stream.println();
        }
        System.out.println("> InputMessageWindow : printAll : --------------------");
    }

    @Override
    public InputMessageWindow clone() {
        InputMessageWindow result = (InputMessageWindow)super.clone();
        return result;
    }

    @Override
    public String toString() {
        return "InputMessageWindow{choiceLabels=" + this.choiceLabels + ", maxLength=" + this.maxLength + ", choicesLabelModel=" + this.choicesLabelModel + ", charSets=" + this.charSets + ", choiceEffect=" + this.choiceEffect + ", selectedIndexX=" + this.selectedIndexX + ", selectedIndexY=" + this.selectedIndexY + ", inputValueLabel=" + this.inputValueLabel + ", caretIndex=" + this.caretIndex + ", caretBlinkRate=" + this.caretBlinkRate + ", caretX=" + this.caretX + ", caretY=" + this.caretY + ", caretColor=" + this.caretColor + ", commandLabels=" + this.commandLabels + '}';
    }
}

