/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kinugasa.object.Model;
import kinugasa.ui.TextLabel;

public abstract class LabelModel
extends Model {
    private static Font DEFALUT_FONT = new Font("Monospaced", 0, 16);
    private static Color DEFULT_COLOR = Color.ORANGE;
    private static final long serialVersionUID = 3188375963284932612L;
    private Font font;
    private Color color;
    public static final LabelModel STANDARD = new LabelModel(){
        private static final long serialVersionUID = -6879469600761885933L;

        @Override
        public void drawText(Graphics2D g, TextLabel l) {
            this.setProperty(g);
            g.drawString(l.getVisibleText(), (float)((int)l.getX()), (float)((int)l.getY()) + this.getFontSize());
            if (l.getTimeCounter().isReaching() && !l.isAllTextVisible()) {
                l.nextChar();
            }
        }
    };

    public static Font getDefaultFont() {
        return DEFALUT_FONT;
    }

    public static void setDefaultFont(Font font) {
        DEFALUT_FONT = font;
    }

    public static Color getDefaultColor() {
        return DEFULT_COLOR;
    }

    public static void setDefaultColor(Color color) {
        DEFULT_COLOR = color;
    }

    public LabelModel() {
        this.font = DEFALUT_FONT;
        this.color = DEFULT_COLOR;
    }

    public LabelModel(Font f, Color c) {
        this.font = f;
        this.color = c;
    }

    public abstract void drawText(Graphics2D var1, TextLabel var2);

    protected final void setProperty(Graphics2D g) {
        g.setColor(this.color);
        g.setFont(this.font);
    }

    public final Color getColor() {
        return this.color;
    }

    public final LabelModel setColor(Color color) {
        this.color = color;
        return this;
    }

    public final float getFontSize() {
        return this.font.getSize2D();
    }

    public final LabelModel setFontSize(float size) {
        this.font = this.font.deriveFont(size);
        return this;
    }

    public final Font getFont() {
        return this.font;
    }

    public final LabelModel setFont(Font font) {
        this.font = font;
        return this;
    }

    @Override
    public LabelModel clone() {
        return (LabelModel)super.clone();
    }
}

