/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import kinugasa.contents.sound.Sound;
import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.Sprite;
import kinugasa.ui.LabelModel;
import kinugasa.ui.MessageWindowModel;
import kinugasa.ui.TextLabel;
import kinugasa.util.TimeCounter;

public class MessageWindow
extends BasicSprite {
    private static String separator = "\n";
    private static final long serialVersionUID = 8737215838540638322L;
    protected TextLabel[] labels;
    private MessageWindowModel windowModel;
    private Sprite icon;

    public static String getSeparator() {
        return separator;
    }

    public static void setSeparator(String separator) {
        MessageWindow.separator = separator;
    }

    public MessageWindow(float x, float y, float width, float height, MessageWindowModel wm, TextLabel ... label) throws NullPointerException {
        super(x, y, width, height);
        if (label == null) {
            throw new NullPointerException("! > MessageWindow : LABEL == null !");
        }
        this.windowModel = wm;
        this.setLabels(this.labels);
    }

    public MessageWindow(float x, float y, float width, float height, MessageWindowModel wm, LabelModel lm, String text) throws NullPointerException {
        super(x, y, width, height);
        if (text == null) {
            throw new NullPointerException("! > MessageWindow : TEXT == null !");
        }
        this.windowModel = wm;
        this.setText(text, lm);
    }

    public MessageWindow(float x, float y, float width, float height, MessageWindowModel wm, LabelModel lm, TimeCounter tc, String text) throws NullPointerException {
        super(x, y, width, height);
        if (text == null) {
            throw new NullPointerException("! > MessageWindow : TEXT == null !");
        }
        this.windowModel = wm;
        this.setText(text, tc, lm);
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        this.windowModel.drawWindow(g, this);
        if (this.icon != null && this.isAllTextVisible()) {
            this.icon.draw(g);
        }
    }

    public void setText(String text, TimeCounter tc) {
        this.setText(text, tc, this.labels != null && this.labels.length != 0 ? this.labels[0].getLabelModel() : LabelModel.STANDARD);
    }

    public void setText(String text, LabelModel lm) {
        String[] msg = text.split(separator);
        Sound sound = null;
        if (this.labels != null) {
            for (TextLabel label : this.labels) {
                if (label.getSound() == null) continue;
                sound = label.getSound();
                break;
            }
        }
        this.labels = new TextLabel[msg.length];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new TextLabel(0.0f, 0.0f, msg[i], lm);
        }
        this.windowModel.initLabels(this);
        if (sound != null) {
            this.setSound(sound);
        }
    }

    public void setText(String text, TimeCounter tc, LabelModel lm) {
        String[] msg = text.split(separator);
        Sound sound = null;
        if (this.labels != null) {
            for (TextLabel label : this.labels) {
                if (label.getSound() == null) continue;
                sound = label.getSound();
                break;
            }
        }
        this.labels = new TextLabel[msg.length];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new TextLabel(0.0f, 0.0f, msg[i], 0, tc.clone(), lm);
        }
        this.windowModel.initLabels(this);
        if (sound != null) {
            this.setSound(sound);
        }
    }

    public void setText(String text) {
        LabelModel model = this.labels != null && this.labels.length > 1 ? this.labels[0].getLabelModel() : LabelModel.STANDARD;
        TimeCounter tc = this.labels != null && this.labels.length > 1 ? this.labels[0].getTimeCounter() : TimeCounter.TRUE;
        tc = tc.clone();
        tc.reset();
        this.setText(text, tc, model);
    }

    public final void setLabels(TextLabel[] labels) {
        this.labels = labels;
        this.windowModel.initLabels(this);
    }

    public TextLabel[] getLabels() {
        return this.labels;
    }

    public TextLabel getLabel(int idx) throws ArrayIndexOutOfBoundsException {
        return this.labels[idx];
    }

    public void setWindowModel(MessageWindowModel windowModel) {
        this.windowModel = windowModel;
        windowModel.initIcon(this);
        windowModel.initLabels(this);
    }

    public MessageWindowModel getWindowModel() {
        return this.windowModel;
    }

    public boolean isAllTextVisible() {
        boolean result = true;
        for (int i = 0; i < this.labels.length; ++i) {
            result &= this.labels[i].isAllTextVisible();
        }
        return result;
    }

    public boolean skip() {
        if (!this.isAllTextVisible()) {
            this.allText();
            return true;
        }
        return false;
    }

    public void allText() {
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].allChar();
        }
    }

    public Sprite getIcon() {
        return this.icon;
    }

    public MessageWindow setIcon(Sprite icon) {
        this.icon = icon;
        this.windowModel.initIcon(this);
        return this;
    }

    @Override
    public MessageWindow clone() {
        MessageWindow w = (MessageWindow)super.clone();
        w.windowModel = this.windowModel.clone();
        w.icon = this.icon.clone();
        return w;
    }

    public void setSound(Sound a) {
        for (TextLabel l : this.labels) {
            l.setSound(a);
        }
    }

    @Override
    public void move() {
        super.move();
        for (TextLabel label : this.labels) {
            label.move();
        }
    }

    @Override
    public void move(MovingModel m) {
        super.move(m);
        for (TextLabel label : this.labels) {
            label.move(m);
        }
    }

    @Override
    public boolean move(Point2D.Float p, Shape s) {
        boolean result = super.move(p, s);
        for (TextLabel label : this.labels) {
            result &= label.move(p, s);
        }
        return result;
    }

    @Override
    public boolean move(float xValue, float yValue, Shape s) {
        boolean result = super.move(xValue, yValue, s);
        for (TextLabel label : this.labels) {
            result &= label.move(xValue, yValue, s);
        }
        return result;
    }
}

