/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import kinugasa.object.Model;
import kinugasa.ui.MessageWindow;
import kinugasa.ui.SimpleWindowModel;
import kinugasa.ui.TextLabel;

public abstract class MessageWindowModel
extends Model {
    private static final long serialVersionUID = -3101131626178958221L;
    public static final MessageWindowModel DQ5_STYLE_WINDOW_MODEL = new SimpleWindowModel(Color.BLACK, Color.WHITE, new Color(140, 140, 140), new Color(32, 32, 32));
    public static final MessageWindowModel FF3_STYLE_WINDOW_MODEL = new SimpleWindowModel(Color.BLACK, new Color(255, 255, 255), new Color(140, 140, 140), new Color(16, 32, 172));

    public abstract void drawWindow(Graphics2D var1, MessageWindow var2);

    public abstract void initLabels(MessageWindow var1);

    protected final void lineUpText(MessageWindow w, float xBlank, float yBlank, float lineGap) {
        TextLabel[] tl = w.getLabels();
        float x = w.getX() + xBlank;
        float y = w.getY() + yBlank;
        for (int i = 0; i < tl.length; ++i) {
            tl[i].setLocation(x, y);
            y += tl[i].getLabelModel().getFontSize() + lineGap;
        }
    }

    protected final void drawText(Graphics2D g, TextLabel ... tl) {
        int i;
        int line = 0;
        for (i = 0; i < tl.length; ++i) {
            if (!tl[i].isAllTextVisible()) {
                line = i;
                break;
            }
            ++line;
        }
        for (i = 0; i < tl.length && i <= line; ++i) {
            if (!tl[i].isAllTextVisible() && tl[i].getTimeCounter().isReaching()) {
                tl[i].nextChar();
            }
            tl[i].draw(g);
        }
    }

    public abstract void initIcon(MessageWindow var1);

    @Override
    public MessageWindowModel clone() {
        return (MessageWindowModel)super.clone();
    }
}

