/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Graphics2D;
import kinugasa.ui.ChoiceEffect;
import kinugasa.ui.LabelModel;
import kinugasa.ui.MessageWindow;
import kinugasa.ui.MessageWindowModel;
import kinugasa.ui.TextLabel;
import kinugasa.util.TimeCounter;

public class SelectableMessageWindow
extends MessageWindow {
    private static final long serialVersionUID = 1982543255115530212L;
    private ChoiceEffect choiceEffect;
    private int selectedIndex = 0;
    private int minIndex;
    private int maxIndex;
    public static final int NOT_YET_SELECTED = -1;

    public SelectableMessageWindow(float x, float y, float width, float height, MessageWindowModel wm, LabelModel lm, String text, int initialIdx, int minIdx, int maxIdx, ChoiceEffect choiceEffect) throws NullPointerException, IllegalArgumentException {
        super(x, y, width, height, wm, lm, text);
        if (minIdx > maxIdx) {
            throw new IllegalArgumentException("! > SelectableMessageWindow : minIdx > maxIdx : min=[" + minIdx + "] max=[" + maxIdx + "]");
        }
        this.selectedIndex = initialIdx;
        this.minIndex = minIdx;
        this.maxIndex = maxIdx;
        this.choiceEffect = choiceEffect;
        this.select(this.selectedIndex);
    }

    public SelectableMessageWindow(float x, float y, float width, float height, MessageWindowModel wm, LabelModel lm, TimeCounter tc, String text, int initialIdx, int minIdx, int maxIdx, ChoiceEffect choiceEffect) throws NullPointerException, IllegalArgumentException {
        super(x, y, width, height, wm, lm, tc, text);
        if (minIdx > maxIdx) {
            throw new IllegalArgumentException("! > SelectableMessageWindow : minIdx > maxIdx : min=[" + minIdx + "] max=[" + maxIdx + "]");
        }
        this.selectedIndex = initialIdx;
        this.minIndex = minIdx;
        this.maxIndex = maxIdx;
        this.choiceEffect = choiceEffect;
        this.select(this.selectedIndex);
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setChoiceEffect(ChoiceEffect choiceEffect) {
        this.choiceEffect = choiceEffect;
    }

    public ChoiceEffect getChoiceEffect() {
        return this.choiceEffect;
    }

    public void nextChoice() {
        ++this.selectedIndex;
        this.clamp();
    }

    public void nextChoiceLoop() {
        if (this.selectedIndex == this.maxIndex) {
            this.selectedIndex = this.minIndex;
        } else {
            this.nextChoice();
        }
    }

    public void prevChoice() {
        --this.selectedIndex;
        this.clamp();
    }

    public void prevChoiceLoop() {
        if (this.selectedIndex == this.minIndex) {
            this.selectedIndex = this.maxIndex;
        } else {
            this.prevChoice();
        }
    }

    public final void select(int idx) throws IllegalArgumentException {
        if (idx >= this.labels.length || this.minIndex > idx || this.maxIndex < idx) {
            throw new IllegalArgumentException("! > SelectableMessageWindow : select :  idx >= labels.length || minIndex > idx || maxIndex < idx : idx=[" + idx + "] labelsLength=[" + this.labels.length + "] min=[" + this.minIndex + "] max=[" + this.maxIndex + "]");
        }
        this.selectedIndex = idx;
        this.clamp();
    }

    protected final void clamp() {
        if (this.selectedIndex > this.maxIndex || this.selectedIndex > this.labels.length - 1) {
            this.selectedIndex = this.maxIndex;
        } else if (this.selectedIndex < this.minIndex || this.selectedIndex < 0) {
            this.selectedIndex = this.minIndex;
        }
    }

    public TextLabel getSelectedLabel() {
        if (!this.isAllTextVisible()) {
            return null;
        }
        return this.labels[this.selectedIndex];
    }

    public int getSelectedIndex() {
        if (!this.isAllTextVisible()) {
            return -1;
        }
        return this.selectedIndex;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (this.isAllTextVisible() && this.choiceEffect != null) {
            this.choiceEffect.draw(g, this.getSelectedLabel());
        }
    }

    @Override
    public SelectableMessageWindow clone() {
        SelectableMessageWindow result = (SelectableMessageWindow)super.clone();
        result.choiceEffect = this.choiceEffect.clone();
        return result;
    }
}

