/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import kinugasa.object.Sprite;
import kinugasa.ui.MessageWindow;
import kinugasa.ui.MessageWindowModel;

public class SimpleClearWindowModel
extends MessageWindowModel {
    private static final long serialVersionUID = -2662571804611406032L;
    private Stroke stroke;
    private Color borderColor;
    private Color innerColor;
    private final int X_BLANK = 6;
    private final int Y_BLANK = 6;
    private final int LINE_GAP = 3;

    public SimpleClearWindowModel(Color borderColor, Color innerColor, float strokeWidth) {
        this.borderColor = borderColor;
        this.innerColor = innerColor;
        this.stroke = new BasicStroke(strokeWidth);
    }

    @Override
    public void drawWindow(Graphics2D g, MessageWindow w) {
        g.setColor(this.innerColor);
        g.fillRoundRect((int)w.getX(), (int)w.getY(), (int)w.getWidth(), (int)w.getHeight(), 6, 6);
        g.setColor(this.borderColor);
        g.setStroke(this.stroke);
        g.drawRoundRect((int)w.getX(), (int)w.getY(), (int)w.getWidth(), (int)w.getHeight(), 6, 6);
        this.drawText(g, w.getLabels());
    }

    @Override
    public void initLabels(MessageWindow w) {
        this.lineUpText(w, 6.0f, 6.0f, 3.0f);
    }

    @Override
    public void initIcon(MessageWindow w) {
        Sprite icon = w.getIcon();
        if (icon == null) {
            return;
        }
        icon.setVisible(true);
        icon.setExist(true);
        float x = w.getX() + w.getWidth() / 2.0f - icon.getWidth();
        float y = w.getY() + w.getHeight() - icon.getHeight() - icon.getHeight() / 2.0f;
        icon.setLocation(x, y);
    }
}

