/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import kinugasa.object.Sprite;
import kinugasa.ui.MessageWindow;
import kinugasa.ui.MessageWindowModel;

public class SimpleWindowModel
extends MessageWindowModel {
    private static final long serialVersionUID = -5369806996238641648L;
    private final Color BORDER_1;
    private final Color BORDER_2;
    private final Color BORDER_3;
    private final Color INNER;
    private final int BORDER_WIDTH = 1;
    private final int X_BLANK = 6;
    private final int Y_BLANK = 6;
    private final int LINE_GAP = 3;

    public SimpleWindowModel(Color BORDER_1, Color BORDER_2, Color BORDER_3, Color INNER) {
        this.BORDER_1 = BORDER_1;
        this.BORDER_2 = BORDER_2;
        this.BORDER_3 = BORDER_3;
        this.INNER = INNER;
    }

    @Override
    public void drawWindow(Graphics2D g, MessageWindow w) {
        g.setColor(this.BORDER_1);
        g.fillRoundRect((int)w.getX(), (int)w.getY(), (int)w.getWidth(), (int)w.getHeight(), 6, 6);
        g.setColor(this.BORDER_3);
        g.fillRoundRect((int)w.getX() + 1, (int)w.getY() + 1, (int)w.getWidth() - 2, (int)w.getHeight() - 2, 6, 6);
        g.setColor(this.BORDER_2);
        g.fillRoundRect((int)w.getX() + 2, (int)w.getY() + 2, (int)w.getWidth() - 4, (int)w.getHeight() - 4, 6, 6);
        g.setColor(this.BORDER_3);
        g.fillRoundRect((int)w.getX() + 3, (int)w.getY() + 3, (int)w.getWidth() - 6, (int)w.getHeight() - 6, 6, 6);
        g.setColor(this.INNER);
        g.fillRoundRect((int)w.getX() + 4, (int)w.getY() + 4, (int)w.getWidth() - 8, (int)w.getHeight() - 8, 6, 6);
        this.drawText(g, w.getLabels());
    }

    @Override
    public void initLabels(MessageWindow w) {
        this.lineUpText(w, 6.0f, 6.0f, 3.0f);
    }

    @Override
    public void initIcon(MessageWindow w) {
        Sprite icon = w.getIcon();
        if (icon == null) {
            return;
        }
        icon.setVisible(true);
        icon.setExist(true);
        float x = w.getX() + w.getWidth() / 2.0f - icon.getWidth();
        float y = w.getY() + w.getHeight() - icon.getHeight() - icon.getHeight() / 2.0f;
        icon.setLocation(x, y);
    }
}

