/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Graphics2D;
import kinugasa.contents.sound.Sound;
import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.VectorF;
import kinugasa.ui.LabelModel;
import kinugasa.util.TimeCounter;

public class TextLabel
extends BasicSprite {
    private static final long serialVersionUID = 5968313475051994644L;
    private StringBuilder text;
    private int idx;
    private TimeCounter timeCounter;
    private LabelModel labelModel;
    private Sound sound = null;

    public TextLabel(float x, float y, String text, LabelModel lm) {
        super(x, y, 1.0f, 1.0f);
        this.text = new StringBuilder(text);
        this.idx = text.length();
        this.timeCounter = TimeCounter.TRUE;
        this.labelModel = lm;
        int w = (int)(((float)lm.getFont().getSize() * 0.66f + 4.0f) * (float)text.length());
        int h = lm.getFont().getSize() + 2;
        this.setSize(w, h);
    }

    public TextLabel(float x, float y, String text, TimeCounter tc, LabelModel lm) {
        super(x, y, 1.0f, 1.0f);
        this.text = new StringBuilder(text);
        this.idx = text.length();
        this.timeCounter = tc;
        this.labelModel = lm;
        int w = (int)(((float)lm.getFont().getSize() * 0.66f + 4.0f) * (float)text.length());
        int h = lm.getFont().getSize() + 2;
        this.setSize(w, h);
    }

    public TextLabel(float x, float y, String text, int idx, TimeCounter tc, LabelModel lm) {
        super(x, y, 1.0f, 1.0f);
        this.text = new StringBuilder(text);
        this.idx = idx;
        this.timeCounter = tc;
        this.labelModel = lm;
        int w = (int)(((float)lm.getFont().getSize() * 0.66f + 4.0f) * (float)text.length());
        int h = lm.getFont().getSize() + 2;
        this.setSize(w, h);
    }

    public TextLabel(float x, float y, float w, float h, VectorF vector, MovingModel movingModel, String text, TimeCounter tc, LabelModel lm) {
        super(x, y, w, h, vector, movingModel);
        this.text = new StringBuilder(text);
        this.idx = text.length();
        this.timeCounter = tc;
        this.labelModel = lm;
    }

    public TextLabel(float x, float y, float w, float h, VectorF vector, MovingModel movingModel, String text, int idx, TimeCounter tc, LabelModel lm) {
        super(x, y, w, h, vector, movingModel);
        this.text = new StringBuilder(text);
        this.idx = idx;
        this.timeCounter = tc;
        this.labelModel = lm;
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        this.labelModel.drawText(g, this);
    }

    public void draw(Graphics2D g, LabelModel model) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        model.drawText(g, this);
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean allout) {
        this.text.replace(0, this.text.length(), text);
        if (this.idx > text.length()) {
            this.idx = text.length();
        }
        if (allout) {
            this.allChar();
        }
    }

    public String getText() {
        return this.text.toString();
    }

    public StringBuilder getStringBuilder() {
        return this.text;
    }

    public String getVisibleText() {
        return this.text.substring(0, this.idx);
    }

    public void setTimeCounter(TimeCounter timeCounter) {
        this.timeCounter = timeCounter;
    }

    public TimeCounter getTimeCounter() {
        return this.timeCounter;
    }

    public void setLabelModel(LabelModel labelModel) {
        this.labelModel = labelModel;
    }

    public LabelModel getLabelModel() {
        return this.labelModel;
    }

    public boolean isAllTextVisible() {
        return this.idx == this.text.length();
    }

    public void nextChar() {
        if (this.text.charAt(this.idx) != ' ' && this.text.charAt(this.idx) != '\u3000' && this.sound != null) {
            if (!this.sound.isLoaded()) {
                this.sound.load();
            }
            this.sound.again();
        }
        this.idx = this.isAllTextVisible() ? this.text.length() : this.idx + 1;
    }

    public void prevChar() {
        this.idx = this.idx == 0 ? 0 : this.idx - 1;
    }

    public void allChar() {
        this.idx = this.text.length();
    }

    public void resetIdx() {
        this.idx = 0;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public Sound getSound() {
        return this.sound;
    }

    @Override
    public TextLabel clone() {
        TextLabel tl = (TextLabel)super.clone();
        tl.text = new StringBuilder(this.text);
        tl.timeCounter = this.timeCounter.clone();
        tl.labelModel = this.labelModel.clone();
        return tl;
    }
}

