/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.util;

import kinugasa.util.ArrayIndexModel;

public class SequentialIndex
extends ArrayIndexModel {
    private static final long serialVersionUID = -5792984578642711312L;
    private int index;
    private boolean loop;
    private boolean toPlus;

    public SequentialIndex() {
        this(0, true, true);
    }

    public SequentialIndex(int index) {
        this(index, true, true);
    }

    public SequentialIndex(boolean loop) {
        this(0, loop, true);
    }

    public SequentialIndex(boolean loop, boolean toPlus) {
        this(0, loop, toPlus);
    }

    public SequentialIndex(int index, boolean loop) {
        this(index, loop, true);
    }

    public SequentialIndex(int index, boolean loop, boolean toPlus) {
        this.index = index;
        this.loop = loop;
        this.toPlus = toPlus;
    }

    @Override
    public int index(int arrayLength) {
        if (this.toPlus) {
            if (this.index >= arrayLength - 1) {
                if (!this.loop) {
                    return arrayLength - 1;
                }
                this.index = 0;
            }
            return this.index++;
        }
        if (this.index == -1) {
            if (!this.loop) {
                return 0;
            }
            this.index = arrayLength - 1;
        }
        return this.index--;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setToPlus(boolean toPlus) {
        this.toPlus = toPlus;
    }

    public boolean isToPlus() {
        return this.toPlus;
    }

    @Override
    public ArrayIndexModel clone() {
        return super.clone();
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.index;
        hash = 71 * hash + (this.loop ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequentialIndex other = (SequentialIndex)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.loop == other.loop;
    }

    public String toString() {
        return "SequentialIndex{index=" + this.index + ", loop=" + this.loop + ", toPlus=" + this.toPlus + '}';
    }
}

