/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.util;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public final class StdOutTracer {
    private static StdOutTracer instance;
    private JFrame frame;
    private JPanel topPanel;
    private JScrollPane scrollPane;
    private StreamTextArea textArea;
    private JPanel southPanel;
    private JButton saveButton;
    private JButton clearButton;
    private JButton closeButton;
    private JButton exitButton;
    private ActionListener closeButtonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StdOutTracer.this.frame.dispose();
                }
            });
        }
    };
    private ActionListener exitButtonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showConfirmDialog(StdOutTracer.this.frame, "System.exit(0)", "exit?", 0, 3);
            if (result == 0) {
                System.exit(0);
            }
        }
    };
    private ActionListener clearButtonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StdOutTracer.this.textArea.setText("");
        }
    };
    private ActionListener saveButtonActionListener = new ActionListener(){
        private final String defaultPath = System.getProperty("user.home") + "/Desktop/LOG_" + System.currentTimeMillis() + ".txt";
        private final FileFilter TXT_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".txt") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb(*.txt)";
            }
        };

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = StdOutTracer.this.textArea.getText().replaceAll("\n", System.getProperty("line.separator"));
            File file = this.selectFile();
            if (file != null) {
                this.save(file, text);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save(File file, String text) {
            FileWriter fr = null;
            try {
                fr = new FileWriter(file);
                BufferedWriter br = new BufferedWriter(fr);
                br.write(text, 0, text.length());
                br.close();
            }
            catch (IOException ex) {
                JOptionPane.showConfirmDialog(StdOutTracer.this.frame, ex, "IOException", -1, 0);
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showConfirmDialog(StdOutTracer.this.frame, ex, "IOException", -1, 0);
                }
            }
        }

        private File selectFile() {
            File defaultFile = new File(this.defaultPath);
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(defaultFile);
            chooser.setFileFilter(this.TXT_FILE_FILTER);
            int rc = chooser.showSaveDialog(StdOutTracer.this.frame);
            if (rc != 0) {
                return null;
            }
            return chooser.getSelectedFile();
        }
    };

    private StdOutTracer() {
        this.frame = new JFrame("stdout/stderr");
        this.frame.setDefaultCloseOperation(0);
        this.frame.setBounds(0, 0, 512, 680);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.textArea = new StreamTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.scrollPane.setViewportView(this.textArea);
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new BoxLayout(this.southPanel, 0));
        this.saveButton = new JButton("save");
        this.saveButton.addActionListener(this.saveButtonActionListener);
        this.clearButton = new JButton("clear");
        this.clearButton.addActionListener(this.clearButtonActionListener);
        this.closeButton = new JButton("close");
        this.closeButton.addActionListener(this.closeButtonActionListener);
        this.exitButton = new JButton("exit");
        this.exitButton.addActionListener(this.exitButtonActionListener);
        this.southPanel.add(this.saveButton);
        this.southPanel.add(this.clearButton);
        this.southPanel.add(this.closeButton);
        this.southPanel.add(this.exitButton);
        this.topPanel.add("Center", this.scrollPane);
        this.topPanel.add("South", this.southPanel);
        this.frame.add(this.topPanel);
    }

    public static void use() {
        if (instance == null) {
            instance = new StdOutTracer();
        }
        if (StdOutTracer.instance.frame.isVisible()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                instance.frame.setVisible(true);
            }
        });
    }

    private static class VisualStream
    extends ByteArrayOutputStream {
        private StreamTextArea tArea;

        private VisualStream(StreamTextArea tArea) {
            this.tArea = tArea;
        }

        @Override
        public void write(byte[] b) throws IOException {
            super.write(b);
            this.tArea.addText(this.toString());
            this.reset();
        }

        @Override
        public synchronized void write(int b) {
            super.write(b);
            this.tArea.addText(this.toString());
            this.reset();
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            super.write(b, off, len);
            this.tArea.addText(this.toString());
            this.reset();
        }
    }

    private static class StreamTextArea
    extends JTextArea {
        private static final long serialVersionUID = -978306416238062009L;
        private PrintStream stream;

        private StreamTextArea() {
            this.setEditable(false);
            this.stream = new PrintStream(new VisualStream(this));
            System.setOut(this.stream);
            System.setErr(this.stream);
        }

        public void addText(final String str) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StreamTextArea.this.append(str);
                }
            });
        }
    }
}

