/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.util;

import kinugasa.util.TimeCounter;
import kinugasa.util.annotations.CallSuper;
import kinugasa.util.annotations.CallTiming;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.VirtualMethod;

public class SystemTimeCounter
extends TimeCounter {
    private static final long serialVersionUID = -4734476685297706601L;
    private long endTime;
    private long waitTime;
    private boolean running = false;

    public SystemTimeCounter(long milliSec) {
        this.endTime = System.currentTimeMillis() + milliSec;
        this.waitTime = milliSec;
    }

    @Override
    public boolean isReaching() {
        this.running = true;
        if (System.currentTimeMillis() > this.endTime) {
            this.endTime = System.currentTimeMillis() + this.waitTime;
            return true;
        }
        return false;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
        this.endTime = System.currentTimeMillis() + waitTime;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    @Override
    public boolean isEnded() {
        return this.isReaching();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void reset() {
        this.endTime = System.currentTimeMillis() + this.waitTime;
    }

    @Override
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    @VirtualMethod
    public SystemTimeCounter clone() {
        return (SystemTimeCounter)super.clone();
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (int)(this.endTime ^ this.endTime >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemTimeCounter other = (SystemTimeCounter)obj;
        return this.endTime == other.endTime;
    }

    public String toString() {
        return "SystemTimeCounter{endTime=" + this.endTime + '}';
    }
}

