/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.graphics;

/**
 * Kinugasa : ARGBColor : 4oCgARGB`̐FҏW邽߂̃[eBeBł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_1:37:59<br>
 * @author Dra0211<br>
 */
public final class ARGBColor {

	/** ARGB̃At@̃}XNlł. */
	public static final int ARGB_ALPHA_MASK = 0xFF000000;
	/** ARGBRED̃}XNlł. */
	public static final int ARGB_RED_MASK = 0x00FF0000;
	/** ARGBGREEÑ}XNlł. */
	public static final int ARGB_GREEN_MASK = 0x0000FF00;
	/** ARGBBLUẼ}XNlł. */
	public static final int ARGB_BLUE_MASK = 0x000000FF;
	//
	/** At@̊Sɕsłlł. */
	public static final int ALPHA_OPAQUE = 255;
	/** At@̊Sɓłlł. */
	public static final int ALPHA_TRANSPARENT = 0;
	//
	/** At@255ɐݒ肵ꍇɂȂ銮SɓȐFł. */
	public static final int CLEAR_BLACK = 0x00000000;
	/** At@255ɐݒ肵ꍇɂȂ銮SɓȐFł.
	 * ̒萔́AAPLHAȊO̗vfւ̃}XNƂĂgpł܂B */
	public static final int CLEAR_WHITE = 0x00FFFFFF;
	/** sȍł. */
	public static final int BLACK = 0xFF000000;
	/** sȔł. */
	public static final int WHITE = 0xFFFFFFFF;
	/** sȐԂł. */
	public static final int RED = 0xFFFF0000;
	/** sȗ΂ł. */
	public static final int GREEN = 0xFF00FF00;
	/** sȐł. */
	public static final int BLUE = 0xFF0000FF;
	/** sȖ邢DFł. */
	public static final int LIGHTGRAY = 0xFFC0C0C0;
	/** sȊDFł. */
	public static final int GRAY = 0xFF808080;
	/** sȈÂDFł. */
	public static final int DARKGRAY = 0xFF404040;
	/** sȃIWł. */
	public static final int ORANGE = 0xFFFFC800;
	/** sȉFł. */
	public static final int YELLOW = 0xFFFFFF00;
	/** sȃ}[^ł. */
	public static final int MAGENTA = 0xFFFF00FF;
	/** sȃVAł. */
	public static final int CYAN = 0xFF00FFFF;

	/**
	 * [eBeBNXł.
	 */
	private ARGBColor() {
	}

	/**
	 * F񂪔͈͓𒲂ׂ܂.
	 *
	 * @param a At@.<br>
	 * @param r RED.<br>
	 * @param g GREEN.<br>
	 * @param b BLUE.<br>
	 *
	 * @throws IllegalArgumentException ͈͊Ȍꍇ.<br>
	 */
	private static void checkColor(int a, int r, int g, int b) throws IllegalArgumentException {
		String badComp = "";
		if (a < 0 || a > 255) {
			badComp += " A";
		}
		if (r < 0 || r > 255) {
			badComp += " R";
		}
		if (g < 0 || g > 255) {
			badComp += " G";
		}
		if (b < 0 || b > 255) {
			badComp += " B";
		}
		if (!"".equals(badComp)) {
			throw new IllegalArgumentException("out of range : " + badComp);
		}
	}

	/**
	 * F񂪔͈͓𒲂ׂ܂.
	 *
	 * @param a At@.<br>
	 * @param r RED.<br>
	 * @param g GREEN.<br>
	 * @param b BLUE.<br>
	 *
	 * @return ͈͓̂ƂtrueԂ.<br>
	 */
	public static boolean checkRange(int a, int r, int g, int b) {
		try {
			checkColor(a, r, g, b);
			return true;
		} catch (IllegalArgumentException iae) {
			return false;
		}
	}

	/**
	 * 0255Ŏw肳ꂽFARGBɕϊ.
	 *
	 * @param r RED.<br>
	 * @param g GREEN.<br>
	 * @param b BLUE.<br>
	 *
	 * @return w肳ꂽF̕sARGB.<br>
	 *
	 * @throws IllegalArgumentException F񂪔͈͊ÔƂ.<br>
	 */
	public static int toARGB(int r, int g, int b) throws IllegalArgumentException {
		checkColor(255, r, g, b);
		return ARGB_ALPHA_MASK | r << 16 | g << 8 | b;
	}

	/**
	 * 0255Ŏw肳ꂽFARGBɕϊ.
	 *
	 * @param a At@.<br>
	 * @param r RED.<br>
	 * @param g GREEN.<br>
	 * @param b BLUE.<br>
	 *
	 * @return w肳ꂽFARGB.<br>
	 *
	 * @throws IllegalArgumentException F񂪔͈͊ÔƂ.<br>
	 */
	public static int toARGB(int a, int r, int g, int b) {
		checkColor(a, r, g, b);
		return a << 24 | r << 16 | g << 8 | b;
	}

	/**
	 * AWTJ[ARGBɕϊ܂.<br>
	 *
	 * @param c F.<br>
	 *
	 * @return ARGB.<br>
	 */
	public static int toARGB(java.awt.Color c) {
		return c.getRGB();
	}

	/**
	 * ARGBAWTJ[ɕύX܂.
	 *
	 * @param argb ARGB.<br>
	 *
	 * @return AWTJ[.<br>
	 */
	public static java.awt.Color toAWTColor(int argb) {
		return new java.awt.Color(getRed(argb), getGreen(argb), getBlue(argb), getAlpha(argb));
	}

	/**
	 * ARGB񂩂At@𒊏o܂.
	 *
	 * @param argb ARGB.<br>
	 *
	 * @return At@0255̒lƂĕԂ܂.<br>
	 */
	public static int getAlpha(int argb) {
		return argb >> 24 & 0xFF;
	}

	/**
	 * ARGB񂩂RED𒊏o܂.
	 *
	 * @param argb ARGB.<br>
	 *
	 * @return RED0255̒lƂĕԂ܂.<br>
	 */
	public static int getRed(int argb) {
		return argb >> 16 & 0xFF;
	}

	/**
	 * ARGB񂩂GREEN𒊏o܂.
	 *
	 * @param argb ARGB.<br>
	 *
	 * @return GREEN0255̒lƂĕԂ܂.<br>
	 */
	public static int getGreen(int argb) {
		return argb >> 8 & 0xFF;
	}

	/**
	 * ARGB񂩂BLUE𒊏o܂.
	 *
	 * @param argb ARGB.<br>
	 *
	 * @return BLUE0255̒lƂĕԂ܂.<br>
	 */
	public static int getBlue(int argb) {
		return argb & 0xFF;
	}

	/**
	 * RGB̕ϒlixjZo܂.
	 *
	 * @param argb RGB.<br>
	 *
	 * @return x.<br>
	 */
	public static int getRGBAverage(int argb) {
		return (getRed(argb) + getGreen(argb) + getBlue(argb)) / 3;
	}

	/**
	 * 4oCgJ[𐮌`Ԃ܂.
	 * ̃\bh́A"ARGB:[getAlpha(argb)], [getRed(argb)], [getGreen(argb)], [getBlue(argb)]"̌`̕
	 * Ԃ܂.<br>
	 *
	 * @param argb ARGB`4oCgJ[.<br>
	 *
	 * @return `Ԃ.<br>
	 */
	public static String toString(int argb) {
		return "ARGB:[" + getAlpha(argb) + ", " + getRed(argb) + ", " + getGreen(argb) + ", " + getBlue(argb) + "]";
	}
}
