/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.graphics;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import kinugasa.util.ArrayIndexModel;
import kinugasa.util.SequentialIndex;
import kinugasa.util.TimeCounter;

/**
 * Kinugasa : Animation : 摜zAj[VƂčĐ邽߂̉摜ƃCfbNXێ܂.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_1:39:19<br>
 * @author Dra0211<br>
 */
public class Animation implements Iterable<SerializableImage>, Cloneable, Serializable {

	private static final long serialVersionUID = -4399754764280894556L;
	/** Aj[V1̗vf\鎞ԊԊuw肷^CJE^ł. */
	private TimeCounter visibleTime;
	/** Aj[V̑Jڏw肷邽߂̔zCfbNXł. */
	private ArrayIndexModel index;
	/** Aj[VƂčĐ摜̔zł. */
	private SerializableImage[] images;

	/**
	 * VAj[V\z܂.
	 * ̃RXgN^ł́AzCfbNX́{փ[vV[PVȃfɂȂ܂B<br>
	 *
	 * @param visibleTime Aj[V1̉摜̕\Ԃ`^CJE^łB<br>
	 * @param images \摜1ȏ㑗M܂B<br>
	 */
	public Animation(TimeCounter visibleTime, BufferedImage... images) {
		this(visibleTime, new SequentialIndex(), images);
	}

	/**
	 * VAj[V\z܂.
	 * ̃RXgN^ł́AzCfbNX́{փ[vV[PVȃfɂȂ܂B<br>
	 *
	 * @param visibleTime Aj[V1̉摜̕\Ԃ`^CJE^łB<br>
	 * @param images \摜1ȏ㑗M܂B<br>
	 */
	public Animation(TimeCounter visibleTime, SerializableImage... images) {
		this(visibleTime, new SequentialIndex(), images);
	}

	/**
	 * VAj[V\z܂.
	 *
	 * @param visibleTime Aj[V1̉摜̕\Ԃ`^CJE^łB<br>
	 * @param index Aj[V̑Jڏ`z̃CfbNXłB<br>
	 * @param images \摜1ȏ㑗M܂B<br>
	 */
	public Animation(TimeCounter visibleTime, ArrayIndexModel index, BufferedImage... images) {
		this.visibleTime = visibleTime;
		this.index = index;
		this.images = new SerializableImage[images.length];
		for (int i = 0; i < images.length; i++) {
			this.images[i] = new SerializableImage(images[i]);
		}
	}

	/**
	 * VAj[V\z܂.
	 *
	 * @param visibleTime Aj[V1̉摜̕\Ԃ`^CJE^łB<br>
	 * @param index Aj[V̑Jڏ`z̃CfbNXłB<br>
	 * @param images \摜1ȏ㑗M܂B<br>
	 */
	public Animation(TimeCounter visibleTime, ArrayIndexModel index, SerializableImage... images) {
		this.visibleTime = visibleTime;
		this.index = index;
		this.images = images;
	}

	/**
	 * ̃Aj[Vɐݒ肳Ă摜擾܂.
	 *
	 * @return ̃Aj[V̉摜SĂ擾܂B̔z͖hIRs[܂B<br>
	 */
	public SerializableImage[] getImages() {
		return images;
	}

	/**
	 * w肵CfbNXʒũAj[Vvf擾܂.
	 *
	 * @param index CfbNXw肵܂B<br>
	 *
	 * @return w肵CfbNXʒũAj[VvfƂȂ摜Ԃ܂B<br>
	 *
	 * @throws ArrayIndexOutOfBoundsException sȃCfbNX𑗐Mꍇɓ܂B<br>
	 */
	public SerializableImage getImage(int index) throws ArrayIndexOutOfBoundsException {
		return images[index];
	}

	/**
	 * ̃Aj[V̉摜ύX܂.
	 *
	 * @param images V摜z𑗐M܂B<br>
	 */
	public void setImages(SerializableImage... images) {
		this.images = images;
	}

	/**
	 * ̃Aj[V̉摜ύX܂.
	 *
	 * @param images V摜z𑗐M܂B<br>
	 */
	public void setImages(BufferedImage... images) {
		this.images = new SerializableImage[images.length];
		for (int i = 0; i < images.length; i++) {
			this.images[i] = new SerializableImage(images[i]);
		}
	}

	/**
	 * ̃Aj[V̉摜ύX܂.
	 *
	 * @param index Aj[VvfuʒũCfbNXw肵܂B<br>
	 * @param image V摜𑗐M܂B<br>
	 *
	 * @throws ArrayIndexOutOfBoundsException sȃCfbNX𑗐Mꍇɓ܂B<br>
	 */
	public void setImage(int index, BufferedImage image) throws ArrayIndexOutOfBoundsException {
		setImage(index, new SerializableImage(image));
	}

	/**
	 * ̃Aj[V̉摜ύX܂.
	 *
	 * @param index Aj[VvfuʒũCfbNXw肵܂B<br>
	 * @param image V摜𑗐M܂B<br>
	 *
	 * @throws ArrayIndexOutOfBoundsException sȃCfbNX𑗐Mꍇɓ܂B<br>
	 */
	public void setImage(int index, SerializableImage image) {
		images[index] = image;
	}

	/**
	 * Aj[V̑JڏύX܂.
	 *
	 * @param index VJڃASY𑗐M܂B<br>
	 */
	public void setIndex(ArrayIndexModel index) {
		this.index = index;
	}

	/**
	 * ̃Aj[Vɐݒ肳Ăz̃CfbNX擾܂.
	 * ̃\bh́Aݒ肳ĂCfbNXfArrayIndexModelƂĕԂ܂B<br>
	 * ̃\bhpɂɎgꍇ́ALXgCfbNXԂ悤
	 * TuNX쐬邱Ƃł܂B<br>
	 *
	 * @return ̃Aj[Vɐݒ肳ĂCfbNXfԂ܂B<br>
	 */
	public ArrayIndexModel getIndex() {
		return index;
	}

	/**
	 * Aj[V1̗vf̍ĐԂw肷邽߂̃^CJE^ݒ肵܂.
	 *
	 * @param visibleTime V^CJE^𑗐M܂B<br>
	 */
	public void setVisibleTime(TimeCounter visibleTime) {
		this.visibleTime = visibleTime;
	}

	/**
	 * ̃Aj[Vɐݒ肳Ă\ԃJE^擾܂.
	 * ̃\bh́Aݒ肳Ă^CJE^TimeCounterƂĕԂ܂B<br>
	 * ̃\bhpɂɎgꍇ́ALXgJE^Ԃ悤
	 * TuNX쐬邱Ƃł܂B<br>
	 *
	 * @return ̃Aj[Vɐݒ肳Ă^CJE^Ԃ܂B<br>
	 */
	public TimeCounter getVisibleTime() {
		return visibleTime;
	}

	/**
	 * \Ԃ̔s܂.
	 * ݕ\̗vf̕\Ԃo߂ꍇɂ́A
	 * CfbNXXVA`悷ׂ摜ύX܂B<br>
	 */
	public void update() {
		if (visibleTime.isReaching()) {
			index.index(images.length);
		}
	}

	/**
	 * ̃Aj[VŁAݕ\ׂ摜Ԃ܂.
	 *
	 * @return ̃Aj[VŌݕ\vfԂ܂B<br>
	 */
	public SerializableImage getCurrentImage() {
		return images[index.getIndex()];
	}

	/**
	 * ̃Aj[VŁAݕ\ׂ摜Ԃ܂.
	 *
	 * @return ̃Aj[VŌݕ\vfԂ܂B<br>
	 */
	public BufferedImage getCurrentBImage() {
		return images[index.getIndex()].get();
	}

	/**
	 * 摜z̗vfԂ܂.
	 *
	 * @return Aj[VƂčĐvf̐Ԃ܂B<br>
	 */
	public int length() {
		return images.length;
	}

	@Override
	public Iterator<SerializableImage> iterator() {
		return Arrays.asList(images).iterator();
	}

	@Override
	public Animation clone() {
		try {
			Animation result = (Animation) super.clone();
			result.images = this.images.clone();
			result.index = this.index.clone();
			result.visibleTime = this.visibleTime.clone();
			return result;
		} catch (CloneNotSupportedException ex) {
			throw new InternalError("clone failed");
		}
	}

	@Override
	public String toString() {
		return "Animation{" + "visibleTime=" + visibleTime + ", index=" + index + ", images=" + images + '}';
	}
}
