/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.graphics;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * Kinugasa : SerializableImage : VACY\ȉ摜ێNXł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_17:37:15<br>
 * @author Dra0211<br>
 */
public final class SerializableImage implements Serializable {

	private static final long serialVersionUID = 2546606715890158812L;
	/** CX^Xɐݒ肳摜f[^ł. */
	private transient BufferedImage image;

	/**
	 * VACY\摜쐬܂.
	 *
	 * @param image 摜w肵܂B<br>
	 *
	 * @throws NullPointerException imagenull̏ꍇɓ܂B<br>
	 */
	public SerializableImage(BufferedImage image) throws NullPointerException {
		if (image == null) {
			throw new NullPointerException("image is null");
		}
		this.image = image;
	}

	/**
	 * 摜̕擾܂.
	 *
	 * @return 摜̕Ԃ܂B<br>
	 */
	public int getWidth() {
		return image.getWidth();
	}

	/**
	 * 摜̍擾܂.
	 *
	 * @return 摜̍Ԃ܂B<br>
	 */
	public int getHeight() {
		return image.getHeight();
	}

	/**
	 * `\ȉ摜CX^X擾܂.
	 *
	 * @return 摜CX^X擾܂Bnullłꍇ͂܂B<br>
	 */
	public BufferedImage get() {
		return image;
	}

	/**
	 * V摜ݒ肵܂.
	 *
	 * @param image VACY\ɂ摜w肵܂B<br>
	 */
	public void set(BufferedImage image) {
		this.image = image;
	}

	/**
	 * sNZƉ摜̕VACY܂.
	 *
	 * @param stream ރXg[M܂B<br>
	 *
	 * @throws IOException Xg[sOłB<br>
	 */
	private void writeObject(ObjectOutputStream stream) throws IOException {
		stream.defaultWriteObject();
		stream.writeInt(image.getWidth());
		stream.writeObject(ImageUtil.getPixel(image));
	}

	/**
	 * sNZƁA摜𕝂fVACYA`\ȉ摜č\z܂.
	 *
	 * @param stream ǂݍރXg[M܂B<br>
	 *
	 * @throws IOException Xg[sOłB<br>
	 * @throws ClassNotFoundException Xg[sOłB<br>
	 */
	private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
		stream.defaultReadObject();
		int width = stream.readInt();
		int[] pixel = (int[]) stream.readObject();
		image = ImageUtil.newImage(width, pixel.length / width);
		ImageUtil.setPixel(image, pixel);
	}
}
