/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.graphics;

import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.List;
import kinugasa.object.Model;

/**
 * Kinugasa : SpriteSheetCutter : XvCgV[g̐؂oASYJvZ܂.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_13:00:58<br>
 * @author Dra0211<br>
 */
public abstract class SpriteSheetCutter extends Model {

	private static final long serialVersionUID = -1630361870659622865L;

	/**
	 * 摜̃ASYɏ]Đ؂o܂.
	 *
	 * @param base ̉摜ƂɁA摜؂o܂B̉摜͕ύXĂ͂Ȃ܂B<br>
	 *
	 * @return ؂oꂽ摜AXg`ƂĕԂ܂B<br>
	 *
	 * @throws RasterFormatException x[X摜̃TCYÃASYɓK؂łȂꍇɓ邱Ƃł܂B<br>
	 */
	public abstract List<BufferedImage> cut(BufferedImage base) throws RasterFormatException;

	/**
	 * w肳ꂽTCYœ񎟌ɐ؂oVvȃJb^[쐬܂.
	 * @param width ؂ow肵܂B<br>
	 * @param height ؂ow肵܂B<br>
	 * @return w肳ꂽTCYŐ؂oJb^[Ԃ܂B<br>
	 */
	public static SpriteSheetCutter createBlockCutter(final int width, final int height) {
		return new SpriteSheetCutter() {
			private static final long serialVersionUID = -9128550488542255603L;

			@Override
			public List<BufferedImage> cut(BufferedImage base) throws RasterFormatException {
				return ImageUtil.splitAsList(base, width, height);
			}
		};
	}

	@Override
	public SpriteSheetCutter clone() {
		return (SpriteSheetCutter) super.clone();
	}
}
