/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.resource;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Kinugasa : Storage : ASYȂǂ̖\ȃIuWFNgi[}bvł.
 * <br>
 * ̃NX́ANameableNXHashMapɓo^ApӂɃANZXł悤ɂ܂B<br>
 * Xg[Wɂ́AÕIuWFNgo^邱Ƃ͏o܂B
 * Xg[W̗eʂ́AIɊg傳܂B<br>
 * <br>
 * Q[A1̏ꏊNameable̎ۑꍇ́A
 * ̃NXp邱ƂŁAB̕ۑ̈쐬邱Ƃo܂B<br>
 * ̃NX́AVACY\ł͂܂B̂悤ȋ@\́ATuNX
 * `Kv܂B<br>
 * <br>
 *
 * @param <T> ̃Xg[Wgp閽\ȃIuWFNgw肵܂B<br>
 *
 * @version 1.0.0 - 2012/11/18_0:14:31<br>
 * @version 1.0.2 - 2013/01/12_22:16:16<br>
 * @version 1.1.0 - 2013/02/19_00:49<br>
 * @version 1.1.2 - 2013/04/13_19:31<br>
 * @version 2.0.0 - 2013/04/20_17:57<br>
 * @author Dra0211<br>
 */
public class Storage<T extends Nameable> implements Iterable<T> {

	/** Tۊǂ}bvł. */
	private HashMap<String, T> map;

	/**
	 * VXg[W쐬܂.
	 */
	public Storage() {
		map = new HashMap<String, T>(32);
	}

	/**
	 * VXg[W쐬܂.
	 *
	 * @param initialSize }bv̏eʂw肵܂B<br>
	 */
	public Storage(int initialSize) {
		map = new HashMap<String, T>(initialSize);
	}

	/**
	 * w肵ÕIuWFNg擾܂.
	 *
	 * @param key 擾IuWFNg̖Ow肵܂B<br>
	 *
	 * @return w肵OIuWFNgԂ܂B<br>
	 *
	 * @throws NameNotFoundException ݂ȂOw肵ꍇɓ܂B<br>
	 */
	public T get(String key) throws NameNotFoundException {
		if (!contains(key)) {
			throw new NameNotFoundException("! > Storage : get : not found : key=[" + key.toString() + "]");
		}
		return map.get(key);
	}

	/**
	 * w肵L[̗vf܂܂ĂꍇɁA擾܂.<br>
	 *
	 * @param key 擾IuWFNg̃L[w肵܂B<br>
	 *
	 * @return w肵L[̃IuWFNg܂܂Ă΂A܂܂ĂȂnullԂ܂B<br>
	 */
	public T getIfContains(String key) {
		return map.get(key);
	}

	/**
	 * ̃Xg[WɒǉĂIuWFNgׂĎ擾܂.
	 * ̃\bh̖߂l͎QƂł͂܂BV쐬ꂽRNVłB<br>
	 *
	 * @return ۊǂĂ邷ׂẴIuWFNg̃RNVԂ܂BRNVɊi[鏇Ԃ
	 * Xg[WɒǉꂽԂƈv܂B<br>
	 */
	public Collection<T> getAll() {
		return map.values();
	}

	/**
	 * ̃Xg[WɒǉĂIuWFNgׂĎ擾܂.
	 * ̃\bh̖߂l͎QƂł͂܂BV쐬ꂽXgłB<br>
	 *
	 * @return ۊǂĂ邷ׂẴIuWFNg̃XgԂ܂BXgɊi[鏇Ԃ
	 * Xg[WɒǉꂽԂƈv܂B<br>
	 */
	public List<T> asList() {
		return new ArrayList<T>(getAll());
	}

	/**
	 * w肵OIuWFNgi[Ă邩𒲂ׂ܂.
	 *
	 * @param key IuWFNg̖Ow肵܂B<br>
	 *
	 * @return w肵ÕIuWFNg܂܂ĂꍇtrueԂ܂B<br>
	 */
	public boolean contains(String key) {
		return map.containsKey(key);
	}

	/**
	 * w肵OIuWFNgAׂĊi[Ă邩𒲂ׂ܂.
	 *
	 * @param keys IuWFNg̖Ow肵܂B<br>
	 *
	 * @return w肵OSĊ܂܂ĂꍇɌAtrueԂ܂B<br>
	 */
	public boolean containsAll(String... keys) {
		for (String key : keys) {
			if (!contains(key)) {
				return false;
			}
		}
		return true;
	}

	/**
	 * w肵IuWFNgi[Ă邩𒲂ׂ܂.
	 *
	 * @param obj IuWFNgw肵܂B<br>
	 *
	 * @return w肵IuWFNg܂܂ĂꍇtrueԂ܂B<br>
	 */
	public boolean contains(T obj) {
		return contains(obj.getName());
	}

	/**
	 * VIuWFNg}bvɒǉ܂.
	 *
	 * @param val ǉIuWFNgw肵܂B<br>
	 *
	 * @throws DuplicateNameException val̖OɎgpĂƂɓ܂B<br>
	 */
	public void add(T val) throws DuplicateNameException {
		if (contains(val.getName())) {
			throw new DuplicateNameException("! > Storage : add : duplicate name : name=[" + val.getName() + "]");
		}
		map.put(val.getName(), val);
	}

	/**
	 * VIuWFNg}bvɒǉ܂.
	 *
	 * @param values ǉIuWFNgw肵܂B<br>
	 *
	 * @throws DuplicateNameException val̖OɎgpĂƂɓ܂B<br>
	 */
	public void addAll(T... values) throws DuplicateNameException {
		addAll(Arrays.asList(values));
	}

	/**
	 * VIuWFNg}bvɒǉ܂.
	 *
	 * @param values ǉIuWFNgw肵܂B<br>
	 *
	 * @throws DuplicateNameException val̖OɎgpĂƂɓ܂B<br>
	 */
	public void addAll(Collection<? extends T> values) throws DuplicateNameException {
		for (T value : values) {
			add(value);
		}
	}

	/**
	 * IuWFNgA㏑Œǉ܂.
	 * ̃\bh͓OIuWFNgo^Ăꍇɏ㏑܂B<br>
	 *
	 * @param val ǉIuWFNgw肵܂B<br>
	 */
	public void put(T val) {
		map.put(val.getName(), val);
	}

	/**
	 * ̃IuWFNg㏑Œǉ܂.
	 *
	 * @param values ǉIuWFNgw肵܂B<br>
	 */
	public void putAll(T... values) {
		putAll(Arrays.asList(values));
	}

	/**
	 * ̃IuWFNg㏑Œǉ܂.
	 *
	 * @param values ǉIuWFNgw肵܂B<br>
	 */
	public void putAll(Collection<? extends T> values) {
		for (T value : values) {
			put(value);
		}
	}

	/**
	 * w肵OIuWFNg}bv폜܂.
	 *
	 * @param key 폜IuWFNg̖Ow肵܂B<br>
	 */
	public void remove(String key) {
		map.remove(key);
	}

	/**
	 * IuWFNg}bv폜܂.
	 *
	 * @param val 폜IuWFNgw肵܂B<br>
	 */
	public void remove(T val) {
		remove(val.getName());
	}

	/**
	 * w肵OIuWFNg}bv폜܂.
	 *
	 * @param keys 폜IuWFNg̖Ow肵܂B<br>
	 */
	public void removeAll(String... keys) {
		for (String key : keys) {
			remove(key);
		}
	}

	/**
	 * IuWFNg}bv폜܂.
	 *
	 * @param values 폜IuWFNgw肵܂B<br>
	 */
	public void removeAll(T... values) {
		for (T key : values) {
			remove(key.getName());
		}
	}

	/**
	 * IuWFNg}bv폜܂.
	 *
	 * @param values 폜IuWFNgw肵܂B<br>
	 */
	public void removeAll(Collection<? extends T> values) {
		for (T key : values) {
			remove(key.getName());
		}
	}

	/**
	 * }bvɒǉĂIuWFNg̐擾܂.
	 *
	 * @return }bv̗vfԂ܂B<br>
	 */
	public int size() {
		return map.size();
	}

	/**
	 * }bv炷ׂẴIuWFNg폜܂.
	 */
	public void clear() {
		map.clear();
	}

	/**
	 * }bv̗vfł邩𒲂ׂ܂.
	 *
	 * @return }bv̏ꍇtrueԂ܂B<br>
	 */
	public boolean isEmpty() {
		return map.isEmpty();
	}

	/**
	 * ݕێĂSẴIuWFNgXg[ɏo͂܂.
	 * ̃\bh̓fobOpłB<br>
	 *
	 * @param stream oXg[w肵܂B<br>
	 */
	public void printAll(PrintStream stream) {
		stream.println("> Storage : class=[" + getClass() + "]");
		for (T obj : map.values()) {
			stream.println("> Storage : printAll : " + obj.getName());
		}
		stream.println("> Storage : ------------------------");
	}

	/**
	 * ݕێĂSẴIuWFNgXg[ɏo͂܂.
	 * ̃\bh̓fobOpłB<br>
	 *
	 * @param stream oXg[w肵܂B<br>
	 * @param valueOut truew肷ƒlo͂܂B<br>
	 */
	public void printAll(PrintStream stream, boolean valueOut) {
		stream.println("> Storage : class=[" + getClass() + "]");
		for (T obj : map.values()) {
			stream.print("> Storage : printAll : " + obj.getName());
			if (valueOut) {
				stream.print(" : " + obj);
			}
			stream.println();
		}
		stream.println("> Storage : ------------------------");
	}

	/**
	 * w肵OIuWFNgV}bvɊi[ĕԂ܂.
	 * ݂ȂOw肵ꍇ́A̖O͖܂B߂l
	 * }bvɂ́A݂mFꂽIuWFNgi[܂B<br>
	 *
	 * @param names ߂lɒǉIuWFNg̖Ow肵܂B<br>
	 *
	 * @return w肵OIuWFNgV}bvɊi[ĕԂ܂B<br>
	 */
	public Map<String, T> getProperties(String... names) {
		Map<String, T> result = new HashMap<String, T>(names.length);
		for (String name : names) {
			if (contains(name)) {
				result.put(name, get(name));
			}
		}
		return result;
	}

	/**
	 * SĂ̗vfQƂłCe[^Ԃ܂.
	 * vf̏Ԃ́AHashSetɈˑ܂Bяݒ肷Kvꍇ
	 * asListgpĂB<br>
	 *
	 * @return ̃Xg[W̗vfQƂCe[^Ԃ܂B<br>
	 */
	@Override
	public Iterator<T> iterator() {
		return map.values().iterator();
	}

	@Override
	public String toString() {
		return "Storage{" + "map=" + map + '}';
	}
}
