/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.sound;

import java.io.Serializable;

/**
 * Kinugasa : LoopPoint : TEh̃[vʒu肷邽߂̃t[JvZ܂.
 * <br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_18:47:52<br>
 * @author Dra0211<br>
 */
public class LoopPoint implements Serializable {

	private static final long serialVersionUID = 1691827854048865412L;
	/**
	 * TEh̏I[\萔ł.
	 * -1ƓlłB<br>
	 */
	public static final int EOF = -1;
	/**
	 * TEh̊Jn\萔ł.
	 * 0ƓlłB<br>
	 */
	public static final int START = 0;
	//
	/**
	 * t@C̏I[܂ōĐAŏɖ߂ݒł.
	 */
	public static final LoopPoint END_TO_START = new LoopPoint(EOF, START);
	/**
	 * [vgpȂݒł.
	 */
	public static final LoopPoint NO_USE = null;

	public static int valueOf(String valueString)
			throws NumberFormatException {
		if ("EOF".equals(valueString.toUpperCase())) {
			return EOF;
		}
		if ("START".equals(valueString.toUpperCase())) {
			return START;
		}
		return Integer.parseInt(valueString);
	}

	/**
	 * Ԃt[ɕϊ. ߂lintɊۂ߂܂.<br>
	 *
	 * @param sec  ԂbPʂŎw.<br>
	 * @param freq g.̃NX̒萔gpł.<br>
	 *
	 * @return w肳ꂽb̃t[.<br>
	 */
	public static int secToFrame(double sec, int freq) {
		return (int) (sec * freq);
	}
	//
	/**
	 * [vJnʒu.
	 */
	private int from;
	/**
	 * [vɖ߂̈ʒu.
	 */
	private int to;

	/**
	 * [vʒu쐬.
	 *
	 * @param from [vJnʒu.<br>
	 * @param to   [vɖ߂̈ʒu.<br>
	 */
	public LoopPoint(int from, int to) {
		this.from = from;
		this.to = to;
	}

	/**
	 * [vJnʒu擾.
	 *
	 * @return [vJnʒu.<br>
	 */
	public int getFrom() {
		return from;
	}

	/**
	 * [vɖ߂ʒu擾.
	 *
	 * @return [vɖ߂ʒu.<br>
	 */
	public int getTo() {
		return to;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final LoopPoint other = (LoopPoint) obj;
		if (this.from != other.from) {
			return false;
		}
		if (this.to != other.to) {
			return false;
		}
		return true;
	}

	@Override
	public int hashCode() {
		int hash = 3;
		hash = 13 * hash + this.from;
		hash = 13 * hash + this.to;
		return hash;
	}

	@Override
	public String toString() {
		return "LoopPoint from=[" + from + "] : to=[" + to + "]";
	}
}
