/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.sound;

import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.Nameable;
import kinugasa.util.annotations.CastReturnValue;

/**
 * Kinugasa : Sound : TEht@C̍Đ~Ȃǂ̋@\𒊏ۉ邽߂̃C^[tF[Xł.
 * <br>
 * SẴTEhf[^́ÃC^[tF[XKv܂B<br>
 * ʏ̎ł́A[hĂȂTEhɑ΂鑀́As܂B<br>
 * ܂AłɃ[hĂꍇɍēx[h邱Ƃ͂܂B<br>
 * <br>
 * TEh̖OƂ́Aʏ́ApXt@CƂȂ܂B<br>
 * Ƃ΁Ahoge/piyo/fuga.wav̏ꍇfuga.wavOƂȂ܂B<br>
 * <br>
 *
 *
 * @version 1.0.0 - 2013/01/13_18:44:36<br>
 * @author Dra0211<br>
 */
public interface Sound extends Freeable, Nameable {

	@Override
	public String getName();

	/**
	 * TEh̍ĐJn܂.
	 * TEh[v@\T|[gĂꍇ́AݒɂĂ̓[vĐJn܂.<Br>
	 * TEhɍĐĂꍇ͉܂.<br>
	 */
	public void play();

	/**
	 * TEhŏ܂Ŋ߂ĂēxĐ܂.
	 * ʏstopĂяoplayĂяo܂.<br>
	 */
	public void again();//IɍŏɊ߂čēxĐ

	/**
	 * TEȟ݂̃t[ʒuԂ܂.
	 * 
	 * @return ݂̃t[ʒu.<br>
	 */
	public long getFramePosition();

	/**
	 * ̃TEh̃t[̍ő咷Ԃ܂.
	 * 
	 * @return t[̍ő咷.<br>
	 */
	public long getFrameLength();

	/**
	 * TEh̍Đ~čŏ܂Ŋ߂܂.
	 */
	public void stop();

	/**
	 * TEh̍Đꎞ~܂.
	 * playĂяoꂽƂApauseĂ΂ꂽʒuĐ܂.<br>
	 */
	public void pause();

	/**
	 * TEhĐ𒲂ׂ܂.
	 * 
	 * @return Đ̏ꍇtrue,łȂA[hĂȂꍇfalse.<Br>
	 */
	public boolean isRunning();

	/**
	 * TEh̉ʂݒ肵܂.
	 * 
	 * @param vol V.0fŖɂȂ.<br>
	 */
	public void setVolume(float vol);

	@CastReturnValue
	@Override
	public Sound load();

	@CastReturnValue
	@Override
	public Sound free();

	@Override
	public boolean isLoaded();
}
