/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.sound;

import kinugasa.contents.resource.DynamicStorage;
import kinugasa.contents.resource.Freeable;

/**
 * Kinugasa : SoundStorage : WbNׂŃTEhǗ邽߂́AB̕ۑ̈񋟂܂.
 * <br>
 * TEh}bvɂ́ASẴTEh}bv܂܂Ă܂BTEh}bvTEh\zꍇ́A
 * ̃Xg[W炷ׂẴTEhɃANZXł܂B<br>
 * <br>
 * Freeable̎́A}bvɒǉĂ邷ׂẴTEhɍs܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_14:19:07<br>
 * @author Dra0211<br>
 */
public final class SoundStorage extends DynamicStorage<SoundMap> implements Freeable {

	/** ̃NX̗B̃CX^Xł . */
	private static final SoundStorage INSTANCE = new SoundStorage();

	/**
	 * TEhXg[W̃CX^X擾܂.
	 *
	 * @return B̃CX^XԂ܂B<br>
	 */
	public static SoundStorage getInstance() {
		return INSTANCE;
	}

	/**
	 * VOgNXł.
	 */
	private SoundStorage() {
	}

	/**
	 * SẴTEhɉʂݒ肵܂.
	 *
	 * @param vol ݒ肷鉹ʂ𑗐M܂B<br>
	 */
	public void setVolume(float vol) {
		for (SoundMap map : this) {
			map.setVolume(vol);
		}
	}
}
