/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.IllegalFormatException;

/**
 * Kinugasa : CSVReader : CSVt@C[h邽߂̃eLXg[_̎ł.
 * <br>
 * #Ŏn܂s̓RgƂĈ܂Bs͖܂B<br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_20:13:41<br>
 * @author Dra0211<br>
 */
public final class CSVReader extends TextReader<String[]> {

	/**
	 * CSVt@Cp̓ǂݍ݃p[Tł.
	 */
	private static final Reader<String[]> CSV_READER = new Reader<String[]>() {
		private static final long serialVersionUID = 3750536757078114045L;

		@Override
		public String[] parse(String line) throws IllegalFormatException {
			return line.startsWith("#") || "".equals(line) ? null : line.split(",");
		}
	};
	private static final long serialVersionUID = -4134842560863486462L;

	/**
	 * t@Cw肵āAǂݍݗpCSVt@C쐬܂.
	 *
	 * @param file t@Cw肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public CSVReader(File file) throws ContentsFileNotFoundException {
		super(file, CSV_READER);
	}

	/**
	 * t@CpXw肵āAǂݍݗpCSVt@C쐬܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public CSVReader(String filePath) throws ContentsFileNotFoundException {
		super(filePath, CSV_READER);
	}

	@Override
	public CSVReader load() throws IllegalFormatException {
		return (CSVReader) super.load();
	}

	@Override
	public CSVReader free() {
		return (CSVReader) super.free();
	}

	@Override
	public CSVReader add(Collection<? extends String[]> obj) {
		return (CSVReader) super.add(obj);
	}

	@Override
	public CSVReader add(String[] obj) {
		return (CSVReader) super.add(obj);
	}

	@Override
	public CSVReader add(String[]... obj) {
		return (CSVReader) super.add(obj);
	}

	@Override
	public CSVReader add(TextIO<? extends String[]> other) {
		return (CSVReader) super.add(other);
	}

	@Override
	public CSVReader remove(Collection<? extends String[]> obj) {
		return (CSVReader) super.remove(obj);
	}

	@Override
	public CSVReader remove(String[] obj) {
		return (CSVReader) super.remove(obj);
	}

	@Override
	public CSVReader remove(String[]... obj) {
		return (CSVReader) super.remove(obj);
	}

	@Override
	public CSVReader remove(TextIO<? extends String[]> other) {
		return (CSVReader) super.remove(other);
	}

	@Override
	public CSVReader clear() {
		return (CSVReader) super.clear();
	}
}
