/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;

/**
 * Kinugasa : CSVWriter : CSVt@Cނ߂̃eLXgC^̎ł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_20:48:02<br>
 * @author Dra0211<br>
 */
public final class CSVWriter extends TextWriter<String[]> {

	/**
	 * CSVt@Cp̏݃p[Tł.
	 */
	private static final Writer<String[]> CSV_WRITER = new Writer<String[]>() {
		private static final long serialVersionUID = -3861436756890125343L;

		@Override
		public String toString(String[] obj) {
			String result = "";
			for (String elm : obj) {
				result += elm + ",";
			}
			return result.substring(0, result.length() - 1);
		}
	};
	private static final long serialVersionUID = -6214839876950581955L;

	/**
	 * t@Cw肵āAݗpCSVt@C쐬܂.
	 *
	 * @param file t@Cw肵܂B<br>
	 */
	public CSVWriter(File file) {
		super(file, CSV_WRITER);
	}

	/**
	 * t@CpXw肵āAݗpCSVt@C쐬܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 */
	public CSVWriter(String filePath) {
		super(filePath, CSV_WRITER);
	}

	@Override
	public CSVWriter add(Collection<? extends String[]> obj) {
		return (CSVWriter) super.add(obj);
	}

	@Override
	public CSVWriter add(String[] obj) {
		return (CSVWriter) super.add(obj);
	}

	@Override
	public CSVWriter add(String[]... obj) {
		return (CSVWriter) super.add(obj);
	}

	@Override
	public CSVWriter add(TextIO<? extends String[]> other) {
		return (CSVWriter) super.add(other);
	}

	@Override
	public CSVWriter remove(Collection<? extends String[]> obj) {
		return (CSVWriter) super.remove(obj);
	}

	@Override
	public CSVWriter remove(String[] obj) {
		return (CSVWriter) super.remove(obj);
	}

	@Override
	public CSVWriter remove(String[]... obj) {
		return (CSVWriter) super.remove(obj);
	}

	@Override
	public CSVWriter remove(TextIO<? extends String[]> other) {
		return (CSVWriter) super.remove(other);
	}

	@Override
	public CSVWriter clear() {
		return (CSVWriter) super.clear();
	}
}
