/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.IllegalFormatException;
import kinugasa.contents.resource.NameNotFoundException;

/**
 * Kinugasa : INIReader : INIt@C[h邽߂̃eLXg[_̎ł.
 * <br>
 * #Ŏn܂s̓RgƂĈ܂Bs͖܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_20:11:56<br>
 * @author Dra0211<br>
 */
public final class INIReader extends TextReader<Property> {

	/**
	 * INIt@C̓ǂݍݗpp[Tł.
	 */
	private static final Reader<Property> INI_READER = new Reader<Property>() {
		private static final long serialVersionUID = -7632402600321932711L;

		@Override
		public Property parse(String line) throws IllegalFormatException {
			if (!line.startsWith("#") && !"".equals(line) && line.indexOf('=') < 0) {
				throw new IllegalFormatException("! > INI_PARSER : ERROR : line=[" + line + "]");
			}
			if (line.startsWith("#") || "".equals(line)) {
				return null;
			}
			String[] values = line.split("=");
			if (values.length == 1) {
				values = new String[]{values[0], ""};
			}
			return new Property(values[0], values[1]);
		}
	};
	private static final long serialVersionUID = 8688808534234682761L;

	/**
	 * t@Cw肵āAǂݍݗpINIt@C쐬܂.
	 *
	 * @param file t@Cw肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public INIReader(File file) throws ContentsFileNotFoundException {
		super(file, INI_READER);
	}

	/**
	 * t@CpXw肵āAǂݍݗpINIt@C쐬܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public INIReader(String filePath) throws ContentsFileNotFoundException {
		super(filePath, INI_READER);
	}

	@Override
	public INIReader load() throws IllegalFormatException {
		return (INIReader) super.load();
	}

	@Override
	public INIReader free() {
		return (INIReader) super.free();
	}

	/**
	 * w肵OvfĕԂ܂.
	 *
	 * @param name Peoperty̖Ow肵܂B<br>
	 *
	 * @return w肳ꂽOPropertyԂ܂B<br>
	 *
	 * @throws NameNotFoundException w肳ꂽÕIuWFNgłȂꍇɓ܂B<br>
	 */
	public Property get(String name) throws NameNotFoundException {
		for (Property prop : this) {
			if (prop.getName().equals(name)) {
				return prop;
			}
		}
		throw new NameNotFoundException("not found : name=[" + name + "]");
	}

	/**
	 * w肵OvfĕԂ܂.
	 *
	 * @param name Peoperty̖Ow肵܂B<br>
	 *
	 * @return w肳ꂽOPropertyԂ܂BłȂꍇnullԂ܂B<br>
	 */
	public Property getIfContains(String name) {
		for (Property prop : this) {
			if (prop.getName().equals(name)) {
				return prop;
			}
		}
		return null;
	}

	/**
	 * w肵Ovf܂܂Ă邩܂B<br>
	 *
	 * @param name Peoperty̖Ow肵܂B<br>
	 *
	 * @return w肳ꂽOProperty܂܂ĂtrueԂ܂B<br>
	 */
	public boolean contains(String name) {
		return getIfContains(name) != null;
	}

	@Override
	public INIReader add(Collection<? extends Property> obj) {
		return (INIReader) super.add(obj);
	}

	@Override
	public INIReader add(Property obj) {
		return (INIReader) super.add(obj);
	}

	@Override
	public INIReader add(Property... obj) {
		return (INIReader) super.add(obj);
	}

	@Override
	public INIReader add(TextIO<? extends Property> other) {
		return (INIReader) super.add(other);
	}

	@Override
	public INIReader remove(Collection<? extends Property> obj) {
		return (INIReader) super.remove(obj);
	}

	@Override
	public INIReader remove(Property obj) {
		return (INIReader) super.remove(obj);
	}

	@Override
	public INIReader remove(Property... obj) {
		return (INIReader) super.remove(obj);
	}

	@Override
	public INIReader remove(TextIO<? extends Property> other) {
		return (INIReader) super.remove(other);
	}

	@Override
	public INIReader clear() {
		return (INIReader) super.clear();
	}
}
