/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;

/**
 * Kinugasa : INIWriter : INIt@Cނ߂̃eLXgC^̎ł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_20:46:58<br>
 * @author Dra0211<br>
 */
public final class INIWriter extends TextWriter<Property> {

	/**
	 * INIt@Cp̏݃p[Tł.
	 */
	private static final Writer<Property> INI_WRITER = new Writer<Property>() {
		private static final long serialVersionUID = 4025346341761681729L;

		@Override
		public String toString(Property obj) {
			return obj.toString();
		}
	};
	private static final long serialVersionUID = -7871451216587359776L;

	/**
	 * t@Cw肵āAݗpINIt@C쐬܂.
	 *
	 * @param file t@Cw肵܂B<br>
	 */
	public INIWriter(File file) {
		super(file, INI_WRITER);
	}

	/**
	 * t@CpXw肵āAݗpINIt@C쐬܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 */
	public INIWriter(String filePath) {
		super(filePath, INI_WRITER);
	}

	@Override
	public INIWriter add(Collection<? extends Property> obj) {
		return (INIWriter) super.add(obj);
	}

	@Override
	public INIWriter add(Property obj) {
		return (INIWriter) super.add(obj);
	}

	@Override
	public INIWriter add(Property... obj) {
		return (INIWriter) super.add(obj);
	}

	@Override
	public INIWriter add(TextIO<? extends Property> other) {
		return (INIWriter) super.add(other);
	}

	@Override
	public INIWriter remove(Collection<? extends Property> obj) {
		return (INIWriter) super.remove(obj);
	}

	@Override
	public INIWriter remove(Property obj) {
		return (INIWriter) super.remove(obj);
	}

	@Override
	public INIWriter remove(Property... obj) {
		return (INIWriter) super.remove(obj);
	}

	@Override
	public INIWriter remove(TextIO<? extends Property> other) {
		return (INIWriter) super.remove(other);
	}

	@Override
	public INIWriter clear() {
		return (INIWriter) super.clear();
	}
}
