/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kinugasa.contents.resource.Nameable;
import kinugasa.util.annotations.CallSuper;
import kinugasa.util.annotations.CallTiming;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.VirtualMethod;

/**
 * Kinugasa : TextIO : eLXgt@C̓o͂̋ʋ@\`܂.
 * <br>
 * TextIO̖ÓAt@CpXt@Cgp܂B<br>
 * Ƃ΁Ahoge/piyo/fuga.txtȂfuga.txtłB<br>
 * <br>
 * TextIÕf[^𑀍삷郁\bh́AthisCX^X߂Ƃɂ
 * ǏIȗ֐߂Ă܂BSĂTextIO̎́Ã\bh
 * K؂ɃI[o[ChAthis߂Kv܂B<br>
 *
 * @param <T> eLXgt@Ĉ1s̓e\NXw肵܂B
 *            Ƃ΁ACSVt@CłString[]łB<br>
 *
 * @version 1.0.0 - 2013/01/13_19:51:24<br>
 * @author Dra0211<br>
 */
public abstract class TextIO<T> implements Iterable<T>, Nameable, Serializable {

	private static final long serialVersionUID = -4706947051077791206L;
	/** ̃eLXgf[^̃t@CCX^Xł. */
	protected final File file;
	/** f[^̓e\Xgł.
	 * f[^̃CfbNX́AeLXgf[^̍sɑΉ܂B<br>
	 */
	protected final ArrayList<T> data;

	/**
	 * t@Cw肵āAeLXgt@C\z܂.
	 * ʏ́ARXgN^R[ł̓f[^̓ǂݍ݂
	 * t@C̍쐬͍s܂B<br>
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 */
	public TextIO(String filePath) {
		this(new File(filePath));
	}

	/**
	 * t@Cw肵āAeLXgt@C\z܂.
	 * ʏ́ARXgN^R[ł̓f[^̓ǂݍ݂
	 * t@C̍쐬͍s܂B<br>
	 *
	 * @param file t@Cw肵܂B<br>
	 */
	public TextIO(File file) {
		this.file = file;
		data = new ArrayList<T>(32);
	}

	/**
	 * eLXgt@C̓eɑΉAf[^擾܂.
	 *
	 * @return t@C̓eԂ܂BXg̃CfbNXAsԍɑΉĂ܂B<br>
	 */
	public final ArrayList<T> getData() {
		return data;
	}

	/**
	 * f[^̍ŏ̒lԂ܂B
	 *
	 * @return f[^0Ԗڂ̗vfԂ܂Bf[^1ȂꍇnullԂ܂B<br>
	 */
	public final T getFirst() {
		return data.isEmpty() ? null : data.get(0);
	}

	/**
	 * t@CCX^X擾܂.
	 *
	 * @return t@CCX^XԂ܂B<br>
	 */
	public final File getFile() {
		return file;
	}

	/**
	 * vf̃eLXgt@C̖ɒǉ܂.
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.add()R[Kv܂B
	 *
	 * @param obj ǉIuWFNgw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> add(T obj) {
		data.add(obj);
		return this;
	}

	/**
	 * vf̃eLXgt@C̖ɒǉ܂.
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.add()R[Kv܂B
	 *
	 * @param obj ǉIuWFNgw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> add(T... obj) {
		data.addAll(Arrays.asList(obj));
		return this;
	}

	/**
	 * vf̃eLXgt@C̖ɒǉ܂.
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.add()R[Kv܂B
	 *
	 * @param obj ǉIuWFNgw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> add(Collection<? extends T> obj) {
		data.addAll(data);
		return this;
	}

	/**
	 * TextIÔׂĂ̗vfÃeLXgt@C̖ɒǉ܂.
	 * ̃\bh́AǂݍݗpTextIO烍[hf[^ݗpTextIOɔsꍇɗLpłB<br>
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.add()R[Kv܂B
	 *
	 * @param other ǉIuWFNg܂܂ꂽTextIOw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> add(TextIO<? extends T> other) {
		add(other.data);
		return this;
	}

	/**
	 * vf̃eLXgt@C폜܂.
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.remove()R[Kv܂B
	 *
	 * @param obj 폜IuWFNgw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> remove(T obj) {
		data.remove(obj);
		return this;
	}

	/**
	 * vf̃eLXgt@C폜܂.
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.remove()R[Kv܂B
	 *
	 * @param obj 폜IuWFNgw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> remove(T... obj) {
		data.removeAll(Arrays.asList(obj));
		return this;
	}

	/**
	 * vf̃eLXgt@C폜܂.
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.remove()R[Kv܂B
	 *
	 * @param obj 폜IuWFNgw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> remove(Collection<? extends T> obj) {
		data.removeAll(data);
		return this;
	}

	/**
	 * TextIÔׂĂ̗vfÃeLXgt@C폜܂.
	 * ̃\bh́AǂݍݗpTextIO烍[hf[^ݗpTextIOɔsꍇɗLpłB<br>
	 * ̃\bh́ATextIÔׂĂ̎ŃI[o[ChAsuper.remove()R[Kv܂B
	 *
	 * @param other 폜IuWFNg܂܂ꂽTextIOw肵܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> remove(TextIO<? extends T> other) {
		remove(other.data);
		return this;
	}

	/**
	 * SĂ̗vfj܂.
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	public TextIO<T> clear() {
		data.clear();
		return this;
	}

	/**
	 * _ł̍s擾܂.
	 *
	 * @return ̃eLXgf[^̍sԂ܂Bdata̗vfłB<br>
	 */
	public final int size() {
		return data.size();
	}

	/**
	 * f[^1ǉĂȂꍇɁAtrueԂ܂.
	 *
	 * @return dataisEmptyԂ܂B<br>
	 */
	public final boolean isEmpty() {
		return data.isEmpty();
	}

	@Override
	public String toString() {
		return "TextIO{" + "file=" + file + ", data=" + data + '}';
	}

	/**
	 * ǉĂ邷ׂĂ̗vftoStringXg[ɔs܂.
	 * ̃\bh̓fobOpłB<br>
	 *
	 * @param stream sXg[w肵܂B<br>
	 */
	public void printAll(PrintStream stream) {
		stream.println("> TextIO : " + this);
		for (T obj : this) {
			stream.println(obj);
		}
		stream.println("> TextIO : ------------------------");
	}

	@Override
	public Iterator<T> iterator() {
		return data.iterator();
	}

	@Override
	public final String getName() {
		return file.getName();
	}
}
