/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.util.annotations.CallSuper;
import kinugasa.util.annotations.CallTiming;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.VirtualMethod;

/**
 * Kinugasa : TextWriter : eLXgt@C𔭍s߂TextIO̎ł.
 * <br>
 *
 * <br>
 *
 * @param <T> eLXgt@Ĉ1s̓e\NXw肵܂B
 *            Ƃ΁ACSVt@CłString[]łB<br>
 *
 * @version 1.0.0 - 2013/01/13_20:20:00<br>
 * @author Dra0211<br>
 */
public class TextWriter<T> extends TextIO<T> {

	private static final long serialVersionUID = 6062888702166716010L;
	/** ^T𕶎ɔs邽߂̃C^[ł. */
	private Writer<T> writer;

	/**
	 * t@CƃC^[w肵āAݗpt@C\z܂.
	 *
	 * @param file   t@Cw肵܂B<br>
	 * @param writer ɕϊ郉C^[w肵܂B<br>
	 */
	public TextWriter(File file, Writer<T> writer) {
		super(file);
		this.writer = writer;
	}

	/**
	 * t@CpXƃC^[w肵āAݗpt@C\z܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 * @param writer   ɕϊ郉C^[w肵܂B<br>
	 */
	public TextWriter(String filePath, Writer<T> writer) {
		super(filePath);
		this.writer = writer;
	}

	/**
	 * eLXgt@C𔭍s܂.
	 * t@C݂Ȃꍇ́AVKɍ쐬܂B<br>
	 * łɑ݂ꍇ͏㏑܂B<br>
	 *
	 * @throws ContentsIOException t@C߂Ȃꍇɓ܂B<br>
	 */
	public void save() throws ContentsIOException {
		FileWriter fw = null;
		BufferedWriter bw = null;
		try {
			fw = new FileWriter(file);
			bw = new BufferedWriter(fw);
			String line;
			for (T obj : this) {
				line = writer.toString(obj);
				bw.write(line, 0, line.length());
				bw.newLine();
			}
			System.out.println("> TextWriter : save : [" + file.getName() + "] : SAVE COMPLETED : size=[" + size() + "]");
		} catch (java.io.IOException ex) {
			throw new ContentsIOException(ex);
		} finally {
			try {
				if (bw != null) {
					bw.close();
				}
				if (fw != null) {
					fw.close();
				}
			} catch (java.io.IOException ex) {
				throw new ContentsIOException(ex);
			}
		}
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> add(Collection<? extends T> obj) {
		return (TextWriter<T>) super.add(obj);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> add(T obj) {
		return (TextWriter<T>) super.add(obj);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> add(T... obj) {
		return (TextWriter<T>) super.add(obj);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> add(TextIO<? extends T> other) {
		return (TextWriter<T>) super.add(other);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> remove(Collection<? extends T> obj) {
		return (TextWriter<T>) super.remove(obj);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> remove(T obj) {
		return (TextWriter<T>) super.remove(obj);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> remove(T... obj) {
		return (TextWriter<T>) super.remove(obj);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> remove(TextIO<? extends T> other) {
		return (TextWriter<T>) super.remove(other);
	}

	@VirtualMethod
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@Override
	public TextWriter<T> clear() {
		return (TextWriter<T>) super.clear();
	}

	/**
	 * C^[擾܂.
	 *
	 * @return ̃eLXgt@C𔭍s邽߂̃C^[Ԃ܂B<br>
	 */
	public Writer<T> getWriter() {
		return writer;
	}

	/**
	 * C^[ݒ肵܂.
	 *
	 * @param writer ̃eLXgt@C𔭍s邽߂̃C^[ݒ肵܂B<br>
	 */
	public void setWriter(Writer<T> writer) {
		this.writer = writer;
	}
}
