package kinugasa.contents.text;

import java.io.Serializable;
import kinugasa.contents.resource.Nameable;

/**
 * Kinugasa : XMLAttribute : XMLɂ""\NXł.
 * <br>
 * ͗vf0ȏݒłL[ƒl̃yAłB<br>
 * Ƃ΁A&lt;hoge fuga=piyo&gt;ł́A
 * fugaƂOpiyoƂl̑\z܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/03/15_7:10:56.<br>
 * @author dra0211 ( <a href="mailto:d0211@live.jp">d0211@live.jp</a>&nbsp;).<br>
 * <br>
 */
public class XMLAttribute implements Nameable, Serializable {

	private static final long serialVersionUID = -2192715007477514049L;
	/** ̖̑Oł. */
	private String name;
	/** ̑̒lł. */
	private String value;

	/**
	 * Oƒl󕶎̐V쐬܂.
	 */
	public XMLAttribute() {
		name = value = "";
	}

	/**
	 * Oƒlw肵āAV쐬܂.
	 * @param name
	 * @param value
	 */
	public XMLAttribute(String name, String value) {
		this.name = name;
		this.value = value;
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * l𐮐ƂĎ擾܂.
	 * @return lInteger.parseIntgpĐɕϊĕԂ܂B<br>
	 * @throws NumberFormatException lϊłȂꍇɓ܂B<br>
	 */
	public int getIntValue() throws NumberFormatException {
		return Integer.parseInt(value);
	}

	/**
	 * lƂĎ擾܂.
	 * @return lFloat.parseFloatgpĎɕϊĕԂ܂B<br>
	 * @throws NumberFormatException lϊłȂꍇɓ܂B<br>
	 */
	public float getFloatValue() throws NumberFormatException {
		return Float.parseFloat(value);
	}

	/**
	 * l_lƂĎ擾܂.
	 * @return lBoolean.parseBooleangpĘ_lɕϊĕԂ܂B<br>
	 */
	public boolean getBool() {
		return Boolean.parseBoolean(value);
	}

	/**
	 * ̖̑OύX܂.
	 * ÓAXMLAttriobuteStorageQƂ邽߁A
	 * dȂꍇ܂B<br>
	 * @param name VOw肵܂B<br>
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * ̑̒lύX܂.
	 * @param value Vlw肵܂B<br>
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * ̑̒l擾܂.
	 * @return lԂ܂B<br>
	 */
	public String getValue() {
		return value;
	}

	@Override
	public String toString() {
		return name + "=" + value;
	}
}
