/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.field;

import java.io.Serializable;
import kinugasa.contents.resource.DuplicateNameException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.Storage;

/**
 * Kinugasa : ChipSet : tB[h}bv1̃CgpA}bv`bṽZbgł.
 * <br>
 * `bvZbg1XMLt@Cɒ`AChipSetStorageNX烍[h܂B<br>
 * 쐬ꂽ`bvZbǵAOȂChipSetStorageNXɎǉ܂B<br>
 * Õ`bvZbgo^ĂꍇAO𓊂܂B<Br>
 * <br>
 * @version 1.0.0 - 2013/04/28_23:26:33<br>
 * @author Dra0211<br>
 */
public class ChipSet extends Storage<MapChip> implements Nameable, Serializable {

	private String name;

	public ChipSet(String name) throws DuplicateNameException {
		this.name = name;
		addThis();
	}

	private void addThis() throws DuplicateNameException {
		ChipSetStorage.getInstance().add(this);
	}

	@Override
	public String getName() {
		return name;
	}
}
