/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.field;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.SerializableImage;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;

/**
 * Kinugasa : ChipSetStorage : SẴ`bvZbgo^Xg[Wł.
 * <br>
 * `bvZbgXMĹAkinugasaChipSet.dtdgp܂B<br>
 * `bvZbgXML烍[hꍇ̃tH[}bgDTDmFĂB<br>
 * <br>
 * @version 1.0.0 - 2013/04/28_23:30:28<br>
 * @author Dra0211<br>
 */
public class ChipSetStorage extends Storage<ChipSet>
		implements XMLFileSupport {

	/** B̃CX^Xł. */
	private static final ChipSetStorage INSTANCE = new ChipSetStorage();

	/**
	 * VOgNXł.
	 * getInstancegpĂB<br>
	 */
	private ChipSetStorage() {
	}

	/**
	 * CX^X擾܂.
	 * @return ChipSetStoragẽCX^XԂ܂B<br>
	 */
	public static ChipSetStorage getInstance() {
		return INSTANCE;
	}

	/**
	 * `bvZbg̍\zs܂.
	 * <br>
	 * {@inheritDoc }
	 * @throws NumberFormatException ؂oTCY̐lint^ɕϊłȂꍇɓ܂B<br>
	 * @throws NameNotFoundException w肳ꂽO`bv
	 * ChipAttributeStorageɓo^ĂȂꍇɓ܂B<br>
	 */
	@Override
	public void readFromXML(String filePath)
			throws IllegalXMLFormatException, ContentsFileNotFoundException,
			ContentsIOException, NumberFormatException,
			NameNotFoundException {
		XMLReader reader = new XMLReader(filePath).load();
		XMLElement root = reader.getFirst();

		if (!"kinugasaChipSet".equals(root.getName())) {
			throw new IllegalXMLFormatException("illegal root node name :" + root);
		}

		List<XMLElement> chipSetElementList = root.getElement("chipSet");
		for (int i = 0, chipSetSize = chipSetElementList.size(); i < chipSetSize; i++) {
			XMLElement chipSetElement = chipSetElementList.get(i);
			ChipSet chipSet = new ChipSet(chipSetElement.getAttributes().get("name").getValue());
			Map<String, BufferedImage> imageMap = ImageUtil.splitAsMap(
					ImageUtil.load(chipSetElement.getAttributes().get("image").getValue()),
					chipSetElement.getAttributes().get("cutWidth").getIntValue(),
					chipSetElement.getAttributes().get("cutHeight").getIntValue());

			List<XMLElement> mapChipElementList = chipSetElement.getElement("mapChip");
			for (int j = 0, mapChipSize = mapChipElementList.size(); j < mapChipSize; j++) {
				XMLElement mapChipElement = mapChipElementList.get(j);
				String mapChipName = mapChipElement.getAttributes().get("name").getValue();
				ChipAttribute attribute = ChipAttributeStorage.getInstance().get(mapChipElement.getAttributes().get("attribute").getValue());
				chipSet.add(new MapChip(
						mapChipName,
						new SerializableImage(imageMap.get(mapChipName)),
						attribute));
			}
			add(chipSet);
		}
		reader.free();
	}
}
