/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.field;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import kinugasa.contents.graphics.SerializableImage;
import kinugasa.contents.resource.Nameable;

/**
 * Kinugasa : MapChip : tB[h}bv\1̃^Cł.
 * <br>
 * }bv`bv͖OA摜ё܂B
 * <br>
 * Oɂ́Aʏ̓XvCgV[g̐؂oʒuݒ肳܂B<br>
 * ̖O̓}bvf[^t@CɋLq`bv̔zu
 * gp܂B<br>
 *
 * ̃}bsOXMLt@Cōs܂B<br>
 * XML}bv`bv쐬ɂ́AChipSetStorageNXgp܂B<br>
 * <br>
 * @version 1.0.0 - 2013/04/28_23:02:47<br>
 * @author Dra0211<br>
 */
public final class MapChip implements Nameable, Serializable {

	private static final long serialVersionUID = -6802142835353191416L;
	/** }bv`bv̈ӓIȖOł.
	 */
	private String name;
	/** ̃}bv`bv̉摜ł. */
	private SerializableImage image;
	/** ̃}bv`bv̑ł. */
	private ChipAttribute attribute;

	/**
	 * V}bv`bv쐬܂.
	 * @param name ӓIȖOw肵܂B
	 * ʏChipSetChipSetStorageXvCgV[g̐؂oʒuƂ
	 * IɖO܂B̖O̓}bvf[^t@CɋLq`bv̔zu
	 * gp܂B<br>
	 * @param image ̃}bv`bv̉摜w肵܂Bʏ
	 * XvCgV[g؂o܂B<br>
	 * @param attribute ̃}bv`bv̑w肵܂B<br>
	 */
	public MapChip(String name, SerializableImage image, ChipAttribute attribute) {
		this.name = name;
		this.image = image;
		this.attribute = attribute;
	}

	/**
	 * ̃`bv擾܂.
	 * @return `bv̑Ԃ܂B<br>
	 */
	public ChipAttribute getAttribute() {
		return attribute;
	}

	/**
	 * ̃`bvݒ肵܂.
	 * @param attribute Vw肵܂B<br>
	 */
	public void setAttribute(ChipAttribute attribute) {
		this.attribute = attribute;
	}

	/**
	 * ̃`bv摜擾܂.
	 * @return 摜Ԃ܂B<br>
	 */
	public SerializableImage getSerializableImage() {
		return image;
	}

	/**
	 * ̃`bv摜擾܂.
	 * @return 摜Ԃ܂B<br>
	 */
	public BufferedImage getImage() {
		return image.get();
	}

	/**
	 * ̃`bv摜ݒ肵܂.
	 * @param image 摜w肵܂B<br>
	 */
	public void setImage(SerializableImage image) {
		this.image = image;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 83 * hash + (this.name != null ? this.name.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final MapChip other = (MapChip) obj;
		if ((this.name == null) ? (other.name != null) : !this.name.equals(other.name)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return "MapChip{" + "name=" + name + ", image=" + image + ", attribute=" + attribute + '}';
	}
}
