/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;

import java.awt.Toolkit;
import kinugasa.util.annotations.Internal;

/**
 * Kinugasa : PlayerConstants : vC[̎s̒萔tB[hɃANZX邽߂̃NXł.
 * <br>
 * ̃NX̏́ASystem.getPropertyToolkit擾܂B<br>
 * ܂ÃNX́AvC[̓̓foCX̎gp󋵂i[B̏ꏊƂȂ܂B
 * ̒l̓Q[̊Jn̂ݎwł܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/02/11_0:12:16<br>
 * @author Dra0211<br>
 */
public final class PlayerConstants {

	private PlayerConstants() {
		SCREEN_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width;
		SCREEN_HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().height;
		OS_NAME = System.getProperty("os.name");
		HOME_PATH = System.getProperty("user.home");
		USER_NAME = System.getProperty("user.name");
		DESKTOP_PATH = HOME_PATH + "/Desktop/";
		USER_COUNTRY = System.getProperty("user.country");
	}
	/** B̃CX^Xł. */
	private static final PlayerConstants INSTANCE = new PlayerConstants();

	/**
	 * CX^X擾܂.
	 * @return B̃CX^X擾܂.<br>
	 */
	public static PlayerConstants getInstance() {
		return INSTANCE;
	}
	/** vC[gpĂʂ̕ł. */
	public final int SCREEN_WIDTH;
	/** vC[gpĂʂ̍ł. */
	public final int SCREEN_HEIGHT;
	/** OS̖Oł. */
	public final String OS_NAME;
	/** vC[̃z[fBNgł. */
	public final String HOME_PATH;
	/** vC[OSAJEgł. */
	public final String USER_NAME;
	/** vC[̃fXNgbṽpXł. */
	public final String DESKTOP_PATH;
	/** vC[̍Ђł. */
	public final String USER_COUNTRY;
	/** Q[pbh̎gp󋵂ł. */
	private boolean usingGamepad;
	/** }EX̎gp󋵂ł. */
	private boolean usingMouse;
	/** L[{[h̎gp󋵂ł. */
	private boolean usingKeyboard;

	/**
	 * Q[Jn̐ݒɂăQ[pbh
	 * gpłԂł邩𒲂ׂ܂.
	 * @return Q[pbhgpݒŃQ[JnꍇtrueԂ܂B<br>
	 */
	public boolean isUsingGamepad() {
		return usingGamepad;
	}

	/**
	 * Q[Jn̐ݒɂăL[{[h
	 * gpłԂł邩𒲂ׂ܂.
	 * @return L[{[hgpݒŃQ[JnꍇtrueԂ܂B<br>
	 */
	public boolean isUsingKeyboard() {
		return usingKeyboard;
	}

	/**
	 * Q[Jn̐ݒɂă}EX
	 * gpłԂł邩𒲂ׂ܂.
	 * @return }EXgpݒŃQ[JnꍇtrueԂ܂B<br>
	 */
	public boolean isUsingMouse() {
		return usingMouse;
	}

	/**
	 * Q[pbh̎gpۂݒ肵܂.
	 * @param usingGamepad gp\ȏꍇtrue𑗐M܂B<br>
	 */
	@Internal
	void setUsingGamepad(boolean usingGamepad) {
		this.usingGamepad = usingGamepad;
	}

	/**
	 * L[{[h̎gpۂݒ肵܂.
	 * @param usingKeyboard gp\ȏꍇtrue𑗐M܂B<br>
	 */
	@Internal
	void setUsingKeyboard(boolean usingKeyboard) {
		this.usingKeyboard = usingKeyboard;
	}

	/**
	 * }EX̎gpۂݒ肵܂.
	 * @param usingMouse gp\ȏꍇtrue𑗐M܂B<br>
	 */
	@Internal
	void setUsingMouse(boolean usingMouse) {
		this.usingMouse = usingMouse;
	}
}
