/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.logic;

import kinugasa.contents.resource.Storage;
import kinugasa.util.ArrayUtil;

/**
 * Kinugasa : CMDArgs : R}hC̈𔻒肵AL^܂.
 * <br>
 * KGFT|[gR}hČ`͈ȉ̒ʂłB<br>
 * <li>tO^</li>
 * ̌`͖O錾ƁAtOONɂȂ܂B<br>
 * Fjava Hoge piyo@ piyo.isOn()=true
 * <br>
 * <li>vpeB^</li>
 * ̌`̓L[ľ`ŁA𑗐M܂BKONɂȂ܂B<br>
 * Fjava Hoge piyo=fuga@@piyo.getValue()=fuga
 * <br>
 * ̋ʂ1̃R}hCɃCR["="܂܂Ă邩ǂ
 * 肳܂B<br>
 * <br>
 * gp\ȃR}ĥAR}hCƂđMȂ̂AXg[Wɒǉ܂B
 * ̂悤ȃR}h́AisOnfalseԂ܂BlnullɂȂ܂B<br>
 * <br>
 * @version 1.0.0 - 2013/04/27_17:08:39<br>
 * @author Dra0211<br>
 */
public final class CMDArgs extends Storage<CMDElement> {

	/** B̃CX^Xł. */
	private static final CMDArgs INSTANCE = new CMDArgs();

	/** VOgNXł. */
	private CMDArgs() {
	}

	/**
	 * CX^X擾܂.
	 * @return CMDArgs̃CX^XԂ܂B<br>
	 */
	public static CMDArgs getInstance() {
		return INSTANCE;
	}

	/**
	 * R}hC𔻒肵Aǉ܂.
	 * @param args NɑMꂽR}hĈ܂ܑM܂B<br>
	 * @param keys R}hCƂĎw肳\̂SẮhOh𑗐M܂B<br>
	 * tO^ł́AR}hĈAvpeB^ł̓CR["="̍
	 * OƂȂ܂B<br>
	 */
	public void parse(String[] args, String... keys) {
		if (args.length == 0 || keys.length == 0) {
			return;
		}
		for (String arg : args) {
			if (arg.contains("=")) {
				String[] keyAndVal = arg.split("=");
				if (!ArrayUtil.contains(keys, keyAndVal[0])) {
					continue;
				}
				add(new CMDElement(keyAndVal[0], keyAndVal[1]));
			} else {
				if (!ArrayUtil.contains(keys, arg)) {
					continue;
				}
				add(new CMDElement(arg, "true"));
			}
		}
		for (String key : keys) {
			if (!contains(key)) {
				add(new CMDElement(key, null));
			}
		}
	}
}
