/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.logic;

import kinugasa.contents.resource.Nameable;
import kinugasa.util.annotations.Internal;

/**
 * Kinugasa : CMDElement : 1̃R}hCvfł.
 * <br>
 * ̗vfR}hCƂđMꂽꍇA̗vfisOn͕KtrueԂ܂B
 * MȂR}hACDMArgsɓo^܂B<br>
 * <br>
 * tO^̈̒l"true"ݒ肳܂B<br>
 * <br>
 * CMDElement̓ꐫ͖Ô݂]܂B͓ÕR}hC
 * M邱ƂȂƍl邽߂łB<br>
 * <br>
 * @version 1.0.0 - 2013/04/27_17:09:33<br>
 * @author Dra0211<br>
 */
public final class CMDElement implements Nameable {

	/** ̖̈Oł. */
	private String name;
	/** ̈̒lł. */
	private String value;

	/**
	 * VCMDElement쐬܂.
	 * lnullłB<Br>
	 * @param name ӓIȖOw肵܂B<br>
	 */
	@Internal
	CMDElement(String name) {
		this.name = name;
	}

	/**
	 * VCMDElement쐬܂.
	 * @param name ӓIȖOw肵܂B<br>
	 * @param value lw肵܂B<br>
	 */
	@Internal
	CMDElement(String name, String value) {
		this.name = name;
		this.value = value;
	}

	/**
	 * ̈̒lԂ܂.
	 * <li>̈NɎw肳Ăꍇ</li>
	 * tO^ł́A"true"ݒ肳܂B<br>
	 * vpeB^ł́ACR["="Ŏw肳ꂽli[܂B<br>
	 * <br>
	 * <li>̈NɎw肳Ȃꍇ</li>
	 * nullݒ肳܂B<br>
	 * <br>
	 * @return ̈ɐݒ肳ꂽlԂ܂B<br>
	 */
	public String getValue() {
		return value;
	}

	/**
	 * lintƂĉ߂A擾܂.
	 * @return Integer.parseInt(getValue())Ԃ܂B<br>
	 * @throws NumberFormatException lϊłȂꍇɓ܂B<br>
	 */
	public int getIntValue() throws NumberFormatException {
		return Integer.parseInt(value);
	}

	/**
	 * lfloatƂĉ߂A擾܂.
	 * @return Float.parseFloat(getValue())Ԃ܂B<br>
	 * @throws NumberFormatException lϊłȂꍇɓ܂B<br>
	 */
	public float getFloatValue() throws NumberFormatException {
		return Float.parseFloat(value);
	}

	/**
	 * ̈NɎw肳ꂽ𒲂ׂ܂.
	 * @return NɎw肳ꂽꍇtrueԂ܂B̒l
	 * getValue()!=nullƓłB<br>
	 */
	public boolean isOn() {
		return value != null;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 71 * hash + (this.name != null ? this.name.hashCode() : 0);
		hash = 71 * hash + (this.value != null ? this.value.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final CMDElement other = (CMDElement) obj;
		if ((this.name == null) ? (other.name != null) : !this.name.equals(other.name)) {
			return false;
		}
		if ((this.value == null) ? (other.value != null) : !this.value.equals(other.value)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return "CMDElement{" + "name=" + name + ", value=" + value + '}';
	}
}
