/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.logic;

import java.awt.Graphics2D;
import java.io.Serializable;
import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.Nameable;
import kinugasa.game.Game;
import kinugasa.object.Drawable;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.Internal;

/**
 * Kinugasa : GameLogic : Q[̂ʂł̃WbNJvZ܂.
 * <br>
 * Q[WbŃAQ[̂ʂł̏`AWbN}l[Wɂ
 * ؂ւ܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_14:34:42<br>
 * @author Dra0211<br>
 */
public abstract class GameLogic implements Nameable, Drawable, Freeable {

	/** ̃WbN̈ӓIȖOł. */
	public final String name;
	/** ̃WbN}l[Wł. */
	protected final LogicManager logicManager;
	/** ̃WbNsQ[ł. */
	protected final Game game;

	/**
	 * VWbN쐬܂.
	 * @param name WbNʂ閼Ow肵܂B<br>
	 * @param logicManager ̃WbN}l[Ww肵܂B<br>
	 * @param game ̃WbNsQ[NXw肵܂B<br>
	 */
	public GameLogic(String name, LogicManager logicManager, Game game) {
		this.name = name;
		this.logicManager = logicManager;
		this.game = game;
	}

	/**
	 * WbN̏s܂.
	 * <br>
	 * {@inheritDoc }
	 * <br>
	 * ̃\bh́AWbNsOɃWbN}l[WĂ΂܂B<br>
	 * @return thisCX^X߂܂BۃNX^ɃLXgĂB<br>
	 */
	@CastReturnValue
	@Override
	public abstract GameLogic load();

	/**
	 * WbN̔js܂.
	 * <br>
	 * {@inheritDoc }
	 * <br>
	 * ̃\bh́AWbN؂ւƂɁAWbN}l[WĂ΂܂B<br>
	 * @return thisCX^X߂܂BۃNX^ɃLXgĂB<br>
	 */
	@CastReturnValue
	@Override
	public abstract GameLogic free();

	@Override
	public abstract boolean isLoaded();

	/**
	 * ̃WbÑC̏`܂.
	 */
	public abstract void update();

	/**
	 * ̃WbN̕`揈`܂.
	 *
	 * @param g ރOtBbNXReLXg𑗐M܂B<br>
	 */
	@Override
	public abstract void draw(Graphics2D g);

	@Override
	public final String getName() {
		return name;
	}

	@Override
	public String toString() {
		return "GameLogic{" + "name=" + name + ", logicManager=" + logicManager + ", game=" + game + '}';
	}
}
