/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.logic;

import java.awt.Graphics2D;
import java.io.Serializable;
import kinugasa.contents.resource.DynamicStorage;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.object.Drawable;

/**
 * Kinugasa : LogicManager : ̃Q[WbNǗ邽߂̃NXł.
 * <br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_14:12:52<br>
 * @author Dra0211<br>
 */
public final class LogicManager extends DynamicStorage<GameLogic> implements Drawable {

	private GameLogic currentLogic;
	/** B̃CX^Xł. */
	private static final LogicManager INSTANCE = new LogicManager();

	/**
	 * VOgNXł.
	 * getInstancegpĂB<br>
	 */
	private LogicManager() {
	}

	/**
	 * CX^X擾܂.
	 * @return LogicManager̃CX^XԂ܂B<br>
	 */
	public static LogicManager getInstance() {
		return INSTANCE;
	}

	/**
	 * ғ̃WbNύX܂.
	 * Ɏs郍WbNnameƂO܂BnameƂÕWbNȂꍇ͗O𓊂܂B<br>
	 * ̃\bhł́A݉ғĂ郍WbN̉(freẽR[)ƐVWbÑ[h(load̃R[)s܂B<br>
	 *
	 * @param name Ɏs郍WbN̖Ow肵܂B<br>
	 *
	 * @throws NameNotFoundException w肵ÕWbN܂܂ĂȂꍇɓ܂B<br>
	 */
	public void changeLogic(String name) throws NameNotFoundException {
		changeLogic(name, true, true);
	}

	/**
	 * ғ̃WbNύX܂.
	 * Ɏs郍WbNnameƂO܂BnameƂÕWbNȂꍇ͗O𓊂܂B<br>
	 * ̃\bhł́AVWbÑ[h(load̃R[)s܂B<br>
	 *
	 * @param name Ɏs郍WbN̖Ow肵܂B<br>
	 * @param free truew肷ƌ݉ғ̃WbN̉(freẽR[)s܂B<br>
	 *
	 * @throws NameNotFoundException w肵ÕWbN܂܂ĂȂꍇɓ܂B<br>
	 */
	public void changeLogic(String name, boolean free) throws NameNotFoundException {
		changeLogic(name, free, true);
	}

	/**
	 * ғ̃WbNύX܂.
	 * Ɏs郍WbNnameƂO܂BnameƂÕWbNȂꍇ͗O𓊂܂B<br>
	 *
	 * @param name Ɏs郍WbN̖Ow肵܂B<br>
	 * @param free truew肷ƌ݉ғ̃WbN̉(freẽR[)s܂B<br>
	 * @param load truew肷ƎɎs郍WbÑ[h(load̃R[)s܂B<br>
	 *
	 * @throws NameNotFoundException w肵ÕWbN܂܂ĂȂꍇɓ܂B<br>
	 */
	public void changeLogic(String name, boolean free, boolean load) throws NameNotFoundException {
		if (!contains(name)) {
			throw new NameNotFoundException("logic not found : name=[" + name + "]");
		}
		if (free && currentLogic != null) {
			currentLogic.free();
		}
		currentLogic = get(name);
		if (load) {
			currentLogic.load();
		}
	}

	/**
	 * ݎgpĂ郍WbNupdateĂяo܂.
	 */
	public void update() {
		currentLogic.update();
	}

	/**
	 * ݎgpĂ郍WbNdrawĂяo܂.
	 * @param g ނ߂̃OtBbNXReLXg𑗐M܂B<br>
	 */
	@Override
	public void draw(Graphics2D g) {
		currentLogic.draw(g);
	}
}
