/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.inputDevice;

/**
 * Kinugasa : GamePadConnection : Q[pbhւ̐ڑmAԂ擾܂.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_13:18:05<br>
 * @author Dra0211<br>
 */
public final class GamePadConnection {

	/**
	 * ̃NX̓[eBeBNXł.CX^Xł܂.
	 * <br>
	 */
	private GamePadConnection() {
	}

	/**
	 * Q[pbh̏Ԃkgp.dllgpČAGamePadState\̂ƂĕԂ܂.
	 * <Br>
	 *
	 * @param index Q[pbh̃CfbNX.ʏ͐ڑ܂USB̃|[gɊU܂.<br>
	 *
	 * @return w肵CfbNX̃Q[pbh̏ԂԂ܂.̃CfbNX̃Q[pbhڑĂȂ
	 * ꍇ́AڑԂ[false]GamePadStateԂ܂B̏ꍇAڑԈȊÕXe[^X͏l(false܂0j
	 * ɐݒ肳܂.<br>
	 */
	public static GamePadState getState(PlayerIndex index) {
		return getState(index.getValue());
	}

	/**
	 * Q[pbh̏Ԃkgp.dllgpČAGamePadState\̂ƂĕԂ܂.
	 * <Br>
	 *
	 * @param index Q[pbh̃CfbNX.ʏ͐ڑ܂USB̃|[gɊU܂.<br>
	 *
	 * @return w肵CfbNX̃Q[pbh̏ԂԂ܂.̃CfbNX̃Q[pbhڑĂȂ
	 * ꍇ́AڑԂ[false]GamePadStateԂ܂B̏ꍇAڑԈȊÕXe[^X͏l(false܂0j
	 * ɐݒ肳܂.<br>
	 */
	public static GamePadState getState(int index) {
		return new GamePadState(getNativeState(index));
	}

	/**
	 * SĂ̏ԂlGamePadStateԂ܂.
	 *
	 * @return SĂ̏ԂlŁAڑĂȂGamePadState.<br>
	 */
	public static GamePadState createClearState() {
		return CLEAR_STATE;
	}

	/**
	 * kgp.dllgpăQ[pbhԂ̃lCeBuȒl擾܂.
	 * <br>
	 * ̃\bh́AGamePadState\zKvȂ߁AgetState(PlaerIndex)
	 * ɓ삵܂BÃ\bhœԂ͐`ĂȂ߁A
	 * ʏgetStategpĂB<br>
	 * ̃\bhJNIgp܂B/kgp.dll[hĂȂꍇÃ\bh͎gpł܂B
	 * kgp.dllDllLoaderNX̐ÓIubNŃ[h܂B<br>
	 * <br>
	 * ̃\bhœԂ́Aȉ̃tH[}bgłB<br>
	 * <br>
	 * [BUTTON_A(0)][BUTTON_BACK(13)]܂ł́A
	 * fW^{^̏Ԃi[Ă܂B<br>
	 * ̃Xe[^X́A{^ĂȂꍇNATIVE_FALSEƓlɂȂ܂B
	 * ĂꍇNATIVE_FALSEłȂli[܂B<br>
	 * <Br>
	 * [TRIGGER_LEFT][TRIGGER_RIGHT]ɂ́AAiOgK[̒li[Ă܂B<Br>
	 * ̒ĺAgK[݂̉ɂ0.0f1.0܂ŘAIɕω܂Bfbh][͒`Ă܂B<br>
	 * <br>
	 * [THUMB_STICK_LEFT_X]A[THUMB_STICK_LEFT_Y]A[THUMB_STICK_RIGHT_X]A[THUMB_STICK_RIGHT_Y]ɂ́AAiOXeBbN
	 * ̒li[Ă܂B̒ĺAXeBbŇXɂ-1.0f1.0f̊ԂŘAIɕωA
	 * Xł͍AYł͉Œ̒lƂȂ܂BXeBbN𑀍삵ĂȂꍇ́AXY̒l0ɂȂ܂B<br>
	 * XeBbN͈̓͂͒ʏ~`Ȃ̂ŁAXeBbNuvuEvɍő܂ŌXꍇA
	 * XY̒lǂől܂͍ŒlɂȂ邱Ƃ͂܂B<br>
	 * fbh][͒`Ă܂B<br>
	 * <br>
	 * [CONNECTION]ɂ́ÃQ[pbh̐ڑԂi[Ă܂B<br>
	 * ̒ĺAڑĂȂNATIVE_FALSEƓlɂȂ܂B<br>
	 * <br>
	 * <br>
	 * ȉɃCfbNXуf[^̗܂B<br>
	 * <br>
	 * <table border="1">
	 *
	 * <tr>
	 * <th>
	 * CfbNX
	 * </th>
	 * <th>
	 * CfbNX̒萔
	 * </th>
	 * <th>
	 * `
	 * </th>
	 * <th>
	 * l̗L͈
	 * </th>
	 * <th>
	 * l
	 * </th>
	 * </tr>
	 *
	 * <tr>
	 * <th>
	 * 013
	 * </th>
	 * <th>
	 * BUTTON_ABUTTON_BACK
	 * </th>
	 * <th>
	 * ꂼ̃{^萔̃CfbNXɃ{^̏Ԃi[<br>
	 * </th>
	 * <th>
	 * NATIVE_FALSEȊO̒l
	 * </th>
	 * <th>
	 * NATIVE_FALSE
	 * </th>
	 * </tr>
	 *
	 * <tr>
	 * <th>
	 * 14A15
	 * </th>
	 * <th>
	 * TRIGGER_LEFTATRIGGER_RIGHT
	 * </th>
	 * <th>
	 * AiOgK[̒li[
	 * </th>
	 * <th>
	 * 0.0f1.0f܂ŉ
	 * </th>
	 * <th>
	 * 0.0f
	 * </th>
	 * </tr>
	 *
	 * <tr>
	 * <th>
	 * 16A17A18A19
	 * </th>
	 * <th>
	 * THUMB_STICK_LEFT_XATHUMB_STICK_LEFT_YA<br>THUMB_STICK_RIGHT_XATHUMB_STICK_RIGHT_Y
	 * </th>
	 * <th>
	 * TXeBbN̒li[<Br>XeBbN̈ʒûƂXY0ɂȂA<br>
	 * Eオ̒lA̒lɂȂ
	 * </th>
	 * <th>
	 * -1.0f1.0f܂ŉ
	 * </th>
	 * <th>
	 * 0.0f
	 * </th>
	 * </tr>
	 *
	 * <tr>
	 * <th>
	 * 20
	 * </th>
	 * <th>
	 * CONNECTION
	 * </th>
	 * <th>
	 * Q[pbh̐ڑԂi[<br>ڑĂꍇANATIVE_TRUEƓlɂȂ
	 * </th>
	 * <th>
	 * NATIVE_FALSEȊO̒l
	 * </th>
	 * <th>
	 * NATIVE_FALSE
	 * </th>
	 * </tr>
	 *
	 * </table>
	 *
	 * @param playerIndex Q[pbh̃CfbNX𑗐M܂BQ[pbh́Aʏ4܂Őڑł܂B
	 * ̒lsȃCfbNX𑗐MĂO͔AuڑĂȂvԂԂ܂.<Br>
	 *
	 * @return w肵CfbNX̃Q[pbh̏ԂԂ܂.<br>
	 */
	public static native float[] getNativeState(int playerIndex);
	//
	/**
	 * kgp.dllɂĕԂAz̒ł.
	 * ̒ĺAgetNativeState(int)ŕԂz̗vf(length)ƈv܂B */
	public static final int LENGTH = 21;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_A = 0;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_B = 1;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_X = 2;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_Y = 3;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_LB = 4;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_RB = 5;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_LEFT_STICK = 6;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_RIGHT_STICK = 7;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_PAD_UP = 8;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_PAD_DOWN = 9;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_PAD_LEFT = 10;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_PAD_RIGHT = 11;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_START = 12;
	/** ̒l̓Q[pbh̃fW^{^ʂ܂. */
	public static final int BUTTON_BACK = 13;
	/** Q[pbh̃AiOgK[ʂ܂. */
	public static final int TRIGGER_LEFT = 14;
	/** Q[pbh̃AiOgK[ʂ܂. */
	public static final int TRIGGER_RIGHT = 15;
	/** Q[pbh̃AiOXeBbNʂ܂. */
	public static final int THUMB_STICK_LEFT_X = 16;
	/** Q[pbh̃AiOXeBbNʂ܂. */
	public static final int THUMB_STICK_LEFT_Y = 17;
	/** Q[pbh̃AiOXeBbNʂ܂. */
	public static final int THUMB_STICK_RIGHT_X = 18;
	/** Q[pbh̃AiOXeBbNʂ܂. */
	public static final int THUMB_STICK_RIGHT_Y = 19;
	/** Q[pbh̎ʏԂi[Ăꏊ̃CfbNXł. */
	public static final int CONNECTION = 20;
	//
	/** kgp.dllɂĒ`AlCeBuȁuFALSEv̏Ԃł. */
	public static final int NATIVE_FALSE = 0;
	/** kgp.dllɂĎgpAgK[̓͂̍ŏlł. */
	public static final int TRIGGER_MIN = 0;
	/** kgp.dllɂĎgpAgK[̓͂̍őlł. */
	public static final int TRIGGER_MAX = 255;
	/** kgp.dllɂĎgpAXeBbN̓͂̍ŏlł. */
	public static final int THUMBSTICK_MIN = Short.MIN_VALUE;
	/** kgp.dllɂĎgpAgK[̓͂̃ftHglł. */
	public static final int THUMBSTICK_CENTER = 0;
	/** kgp.dllɂĎgpAXeBbN̓͂̍őlł. */
	public static final int THUMBSTICK_MAX = Short.MAX_VALUE;
	/** kgp.dllɂĎgpAgK[̓͂̍ŏl̍ől܂ł̐Βlł. */
	public static final int THUMSTICK_ABS_MAX = 65534;
	/** SĂ̏ԂlGamePadStateł. */
	private static final GamePadState CLEAR_STATE = new GamePadState(new float[LENGTH]);
}
