/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.inputDevice;

import java.awt.geom.Point2D;
import static kinugasa.inputDevice.GamePadConnection.*;

/**
 * Kinugasa : GamePadState : Q[pbh̓͏Ԃi[܂.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_13:18:37<br>
 * @author Dra0211<br>
 */
public class GamePadState extends InputDeviceState {

	private static final long serialVersionUID = -3599701264472336389L;

	/**
	 * Ԃ쐬܂BpbP[WvCx[głB
	 *
	 * @param values `ς݂̃f[^BfW^{^NATIVE_FALSE܂͂ȊO̒lA
	 * gK[0f1f܂łfloatAXeBbN-1f1f܂łfloatƂBf[^̕тƗvf
	 * GamePadConnection̒萔ɏ]B<br>
	 *
	 */
	GamePadState(float[] values) {
		buttons = new Buttons(values);
		leftTrigger = new Trigger(values[TRIGGER_LEFT]);
		rightTrigger = new Trigger(values[TRIGGER_RIGHT]);
		leftStick = new ThumbStick(values[THUMB_STICK_LEFT_X], values[THUMB_STICK_LEFT_Y]);
		rightStick = new ThumbStick(values[THUMB_STICK_RIGHT_X], values[THUMB_STICK_RIGHT_Y]);
		connection = values[CONNECTION] != NATIVE_FALSE;
	}
	/** Q[pbh̐ڑԂł. */
	private boolean connection;
	/** Q[pbh̃fW^{^ł. */
	public Buttons buttons;
	/** Q[pbh̍XeBbNł. */
	public ThumbStick leftStick;
	/** Q[pbh̉EXeBbNł. */
	public ThumbStick rightStick;
	/** Q[pbh̍gK[ł. */
	public Trigger leftTrigger;
	/** Q[pbh̉EgK[ł. */
	public Trigger rightTrigger;

	/**
	 * ̃Q[pbhڑĂ邩𒲂ׂ܂.
	 *
	 * @return ڑĂꍇtrueԂAłȂꍇfalseԂ܂B<br>
	 */
	public boolean isConnected() {
		return connection;
	}

	@Override
	public boolean isAnyInput() {
		return buttons.isAnyInput()
				|| leftStick.isAnyInput()
				|| rightStick.isAnyInput()
				|| leftTrigger.isAnyInput()
				|| rightTrigger.isAnyInput();
	}

	@Override
	public boolean isAnyButtonInput() {
		return buttons.isAnyButtonInput()
				|| leftStick.isAnyButtonInput()
				|| rightStick.isAnyButtonInput()
				|| leftTrigger.isAnyButtonInput()
				|| rightTrigger.isAnyButtonInput();
	}

	@Override
	public boolean isEmptyInput() {
		return buttons.isEmptyInput()
				&& leftStick.isEmptyInput()
				&& rightStick.isEmptyInput()
				&& leftTrigger.isEmptyInput()
				&& rightTrigger.isEmptyInput();
	}

	/**
	 * Kinugasa : GamePadState.Buttons : Q[pbh̃{^̏Ԃێ\̂ł.
	 * <br>
	 *
	 * @author dra0211 : <a href="mailto:d0211@live.jp">d0211@live.jp</a> <br>
	 * @version 1.0.0 - 2012/10/06_8:32:26<br>
	 * <br>
	 */
	public final class Buttons extends InputDeviceState {

		private static final long serialVersionUID = 1L;
		/** Q[pbhA{^ł. */
		public final boolean A;
		/** Q[pbhB{^ł. */
		public final boolean B;
		/** Q[pbhX{^ł. */
		public final boolean X;
		/** Q[pbhY{^ł. */
		public final boolean Y;
		/** Q[pbhLB{^ł. */
		public final boolean LEFT_SHOULDER;
		/** Q[pbhRB{^ł. */
		public final boolean RIGHT_SHOULDER;
		/** Q[pbh̍XeBbN{^ł. */
		public final boolean LEFT_STICK;
		/** Q[pbh̉EXeBbN{^ł. */
		public final boolean RIGHT_STICK;
		/** Q[pbh̃pbh{^ł. */
		public final boolean PAD_UP;
		/** Q[pbh̃pbh{^ł. */
		public final boolean PAD_DOWN;
		/** Q[pbh̃pbh{^ł. */
		public final boolean PAD_LEFT;
		/** Q[pbh̃pbhE{^ł. */
		public final boolean PAD_RIGHT;
		/** Q[pbh̃X^[g{^ł. */
		public final boolean START;
		/** Q[pbh̃obN{^ł. */
		public final boolean BACK;

		/**
		 * Q[pbh̏ԂA{^̏ԂĘ_^ɕϊ܂.vCx[gANZXł.
		 *
		 * @param data Q[pbh̏Ԃi[Ăz.<br>
		 */
		private Buttons(float[] data) {
			A = data[BUTTON_A] != NATIVE_FALSE;
			B = data[BUTTON_B] != NATIVE_FALSE;
			X = data[BUTTON_X] != NATIVE_FALSE;
			Y = data[BUTTON_Y] != NATIVE_FALSE;
			LEFT_SHOULDER = data[BUTTON_LB] != NATIVE_FALSE;
			RIGHT_SHOULDER = data[BUTTON_RB] != NATIVE_FALSE;
			LEFT_STICK = data[BUTTON_LEFT_STICK] != NATIVE_FALSE;
			RIGHT_STICK = data[BUTTON_RIGHT_STICK] != NATIVE_FALSE;
			PAD_UP = data[BUTTON_PAD_UP] != NATIVE_FALSE;
			PAD_DOWN = data[BUTTON_PAD_DOWN] != NATIVE_FALSE;
			PAD_LEFT = data[BUTTON_PAD_LEFT] != NATIVE_FALSE;
			PAD_RIGHT = data[BUTTON_PAD_RIGHT] != NATIVE_FALSE;
			START = data[BUTTON_START] != NATIVE_FALSE;
			BACK = data[BUTTON_BACK] != NATIVE_FALSE;
		}

		/**
		 * w肳ꂽ{^̏ԂԂ܂.
		 *
		 * @param b {^.<br>
		 *
		 * @return w肵{^ĂꍇtrueAĂȂꍇfalseԂ.<br>
		 */
		public boolean isPressed(GamePadButtons b) {
			return isPressed(b.getValue());
		}

		/**
		 * w肳ꂽCfbNXtB[h̃{^̏Ԃ܂.
		 * ̃\bh͒ʏAisPressed(GamePadButtons)ƓAɓ삵܂.<br>
		 * AsȃCfbNXMĂfalse߂Ap邱ƂɒӂĂ.<br>
		 *
		 * @param field GamePadConnection̒萔gpătB[hԍ𑗂܂.<br>
		 *
		 * @return w肵tB[h̃{^ĂꍇtrueAĂȂꍇfalseԂ.
		 * sȃCfbNXłꍇfalseԂ.<br>
		 */
		public boolean isPressed(int field) {
			switch (field) {
				case BUTTON_A:
					return A;
				case BUTTON_B:
					return B;
				case BUTTON_X:
					return X;
				case BUTTON_Y:
					return Y;
				case BUTTON_LB:
					return LEFT_SHOULDER;
				case BUTTON_RB:
					return RIGHT_SHOULDER;
				case BUTTON_LEFT_STICK:
					return LEFT_STICK;
				case BUTTON_RIGHT_STICK:
					return RIGHT_STICK;
				case BUTTON_PAD_UP:
					return PAD_UP;
				case BUTTON_PAD_DOWN:
					return PAD_DOWN;
				case BUTTON_PAD_LEFT:
					return PAD_LEFT;
				case BUTTON_PAD_RIGHT:
					return PAD_RIGHT;
				case BUTTON_START:
					return START;
				case BUTTON_BACK:
					return BACK;
				default:
					return false;
			}//sw
		}

		@Override
		public String toString() {
			return "A=" + A + ", B=" + B + ", X=" + X + ", Y=" + Y + ", LEFT_SHOULDER=" + LEFT_SHOULDER + ", RIGHT_SHOULDER=" + RIGHT_SHOULDER + ", LEFT_STICK=" + LEFT_STICK + ", RIGHT_STICK=" + RIGHT_STICK + ", PAD_UP=" + PAD_UP + ", PAD_DOWN=" + PAD_DOWN + ", PAD_LEFT=" + PAD_LEFT + ", PAD_RIGHT=" + PAD_RIGHT + ", START=" + START + ", BACK=" + BACK;
		}

		@Override
		public GamePadState.Buttons clone() {
			return (Buttons) super.clone();
		}

		@Override
		public boolean isAnyInput() {
			return A
					|| B
					|| BACK
					|| LEFT_SHOULDER
					|| LEFT_STICK
					|| PAD_DOWN
					|| PAD_LEFT
					|| PAD_RIGHT
					|| PAD_UP
					|| RIGHT_SHOULDER
					|| RIGHT_STICK
					|| START
					|| X
					|| Y;
		}

		@Override
		public boolean isAnyButtonInput() {
			return A
					|| B
					|| BACK
					|| LEFT_SHOULDER
					|| LEFT_STICK
					|| PAD_DOWN
					|| PAD_LEFT
					|| PAD_RIGHT
					|| PAD_UP
					|| RIGHT_SHOULDER
					|| RIGHT_STICK
					|| START
					|| X
					|| Y;
		}

		@Override
		public boolean isEmptyInput() {
			return A
					&& !B
					&& !BACK
					&& !LEFT_SHOULDER
					&& !LEFT_STICK
					&& !PAD_DOWN
					&& !PAD_LEFT
					&& !PAD_RIGHT
					&& !PAD_UP
					&& !RIGHT_SHOULDER
					&& !RIGHT_STICK
					&& !START
					&& !X
					&& !Y;
		}
	}

	/**
	 * Kinugasa : GamePadState.Trigger : Q[pbh̃gK[̏Ԃێ\̂ł.
	 * <br>
	 *
	 * @author dra0211 : <a href="mailto:d0211@live.jp">d0211@live.jp</a> <br>
	 * @version 1.0.0 - 2012/10/06_8:32:26<br>
	 * <br>
	 */
	public final class Trigger extends InputDeviceState {

		private static final long serialVersionUID = 1L;
		/** gK[̒l. */
		public final float VALUE;

		/**
		 * gK[̒li[܂.
		 *
		 * @param value gK[̒l.<br>
		 */
		private Trigger(float value) {
			this.VALUE = value < triggerDeadZone ? 0f : value;
		}

		@Override
		public String toString() {
			return Float.toString(VALUE);
		}

		@Override
		public GamePadState.Trigger clone() {
			return (Trigger) super.clone();
		}

		@Override
		public boolean isAnyInput() {
			return VALUE != 0.f;
		}

		@Override
		public boolean isAnyButtonInput() {
			return VALUE != 0.f;
		}

		@Override
		public boolean isEmptyInput() {
			return VALUE == 0.f;
		}
	}

	/**
	 * Kinugasa : GamePadState.ThumbStick : Q[pbh̃XeBbN̏Ԃێ\̂ł.
	 * <br>
	 *
	 * @author dra0211 : <a href="mailto:d0211@live.jp">d0211@live.jp</a> <br>
	 * @version 1.0.0 - 2012/10/06_8:32:26<br>
	 * <br>
	 */
	public final class ThumbStick extends InputDeviceState {

		private static final long serialVersionUID = 1L;
		/** XeBbN̏Ԃi[Point. */
		private Point2D.Float value;

		/**
		 * XeBbN̏Ԃi[܂.
		 *
		 * @param x X̒l.<br>
		 * @param y Y̒l.<br>
		 */
		private ThumbStick(float x, float y) {
			this.value = new Point2D.Float(
					Math.abs(x) < thumbStickDeadZone ? 0f : x,
					Math.abs(y) < thumbStickDeadZone ? 0f : y);
		}

		/**
		 * ̃XeBbN̒lPoint2D.FloatƂĎ擾܂.
		 *
		 * @return ̃XeBbN̒l̃N[Ԃ.<br>
		 */
		public Point2D.Float getValue() {
			return (Point2D.Float) value.clone();
		}

		/**
		 * ̃XeBbNX̒l擾܂.
		 *
		 * @return ̃XeBbNX̒l.-11float^ƂĎ擾ł.<br>
		 */
		public float getX() {
			return value.x;
		}

		/**
		 * ̃XeBbNY̒l擾܂.
		 *
		 * @return ̃XeBbNY̒l.-11float^ƂĎ擾ł.<br>
		 */
		public float getY() {
			return value.y;
		}

		@Override
		public String toString() {
			return "x=" + value.x + ", y=" + value.y;
		}

		@Override
		public GamePadState.ThumbStick clone() {
			ThumbStick result = (ThumbStick) super.clone();
			result.value = (Point2D.Float) this.value.clone();
			return result;
		}

		@Override
		public boolean isAnyInput() {
			return getX() != 0.f || getY() != 0.f;
		}

		@Override
		public boolean isAnyButtonInput() {
			return getX() != 0.f || getY() != 0.f;
		}

		@Override
		public boolean isEmptyInput() {
			return getX() == 0.f && getY() == 0.f;
		}
	}
	/** TXeBbÑfbh][ł.͒l̒lɖȂꍇ͓͂0ƂĈ܂.
	 * ftHgł0.189炢ɐݒ肳Ă܂.<br>
	 * ̒l͍ẼXeBbNɓKp܂.<br> */
	private static float thumbStickDeadZone = 0.18921477f;//=6200 / Short.MAX_VALUE

	/**
	 * XeBbÑfbh][擾܂.
	 *
	 * @return XeBbÑfbh][.EʂŁA̒lɖȂ͒l0ƂĈ.<br>
	 */
	public static float getThumbStickDeadZone() {
		return thumbStickDeadZone;
	}

	/**
	 * XeBbÑfbh][ݒ肵܂.
	 *
	 * @param thumbStickDeadZone XeBbÑfbh][.EʂŁA̒lɖȂ͒l0ƂĈ.<br>
	 */
	public static void setThumbStickDeadZone(float thumbStickDeadZone) {
		GamePadState.thumbStickDeadZone = thumbStickDeadZone;
	}
	/** gK[̃fbh][ł.͒l̒lɖȂꍇ͓͂0ƂĈ܂.
	 * ftHgł0ɐݒ肳Ă܂.<br>
	 * ̒l͍ẼgK[ɓKp܂.<br> */
	private static float triggerDeadZone = 0f;

	/**
	 * gK[̃fbh][ݒ肵܂.
	 *
	 * @param triggerDeadZone gK[̃fbh][.EʂŁA̒lɖȂ͒l0ƂĈ.<br>
	 */
	public static void setTriggerDeadZone(float triggerDeadZone) {
		GamePadState.triggerDeadZone = triggerDeadZone;
	}

	/**
	 * gK[̃fbh][擾܂.
	 *
	 * @return gK[̃fbh][.EʂŁA̒lɖȂ͒l0ƂĈ.<br>
	 */
	public static float getTriggerDeadZone() {
		return triggerDeadZone;
	}

	@Override
	public String toString() {
		return "GamePadState{" + "connection:{" + connection + "}, buttons:{"
				+ buttons + "}, leftStick:{" + leftStick + "}, rightStick:{"
				+ rightStick + "}, leftTrigger:{" + leftTrigger + "}, rightTrigger:{"
				+ rightTrigger + "}}";
	}

	@Override
	public GamePadState clone() {
		GamePadState result = (GamePadState) super.clone();
		result.buttons = this.buttons.clone();
		result.leftTrigger = this.leftTrigger.clone();
		result.rightTrigger = this.rightTrigger.clone();
		result.leftStick = this.leftStick.clone();
		result.rightStick = this.rightStick.clone();
		return result;
	}
}
