/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.inputDevice;

import kinugasa.object.Model;

/**
 * Kinugasa : InputDeviceState : ̓foCX̏Ԃi[郂f̃X[p[NXł.
 * <br>
 * ̓foCX̏Ԃ́AN[jO\łB
 * <br>
 * Ԃ͕ύXȂ悤ɁAf[^JvZKv܂B<br>
 * <br>
 * @version 1.0.0 - 2013/04/20_21:27:02<br>
 * @author Dra0211<br>
 */
public abstract class InputDeviceState extends Model {

	private static final long serialVersionUID = -2734450396863917467L;

	/**
	 * TuNX̂݃CX^Xł܂.
	 */
	protected InputDeviceState() {
	}

	/**
	 * _ŁA炩̓͂邩𒲂ׂ܂.
	 *
	 * ̃\bhɂČAfoCX̗vf́AɂĈقȂ܂B<br>
	 *
	 * @return 炩̓͂ꍇtrueԂ܂B<br>
	 */
	public abstract boolean isAnyInput();

	/**
	 * _ŁA炩̃{^Ă邩𒲂ׂ܂.
	 *
	 * ̃\bhɂČAfoCX̗vf́AɂĈقȂ܂B<br>
	 *
	 * @return 炩̃{^ĂꍇtrueԂ܂B<br>
	 */
	public abstract boolean isAnyButtonInput();

	/**
	 * _ŁA͂ĂȂ𒲂ׂ܂.
	 *
	 * ̃\bhɂČAfoCX̗vf́AɂĈقȂ܂B<br>
	 *
	 * @return ͂ĂȂꍇtrueԂ܂B<br>
	 */
	public abstract boolean isEmptyInput();

	@Override
	public InputDeviceState clone() {
		return (InputDeviceState) super.clone();
	}
}
