/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.inputDevice;

import kinugasa.game.PlayerConstants;
import kinugasa.object.FourDirection;

/**
 * Kinugasa : InputState : ̓foCX̏Ԃi[܂.
 * <br>
 * ̃NX́AvC[gpłfoCX̏ԂꌳǗ܂B<br>
 * ̃NXgp邱ƂŁA͏ԂȒPɌł܂B<br>
 * <br>
 * ͏Ԃ̍XVɂ́AȂ̎ԓIRXg܂B<br>
 * getInstance̎gṕA1[v1ɂƂǂ߂ĂB<br>
 * <br>
 * <br>
 * Q[N̐ݒɂāAgpȂfoCXꍇA
 * ̃foCX̏Ԃ͏nullłB<br>
 * <br>
 * @version 1.0.0 - 2013/01/14_14:55:04<br>
 * @author Dra0211<br>
 */
public final class InputState extends InputDeviceState {

	private static final long serialVersionUID = 2349722781837661059L;
	/** ݂̃Q[pbh̏. */
	private GamePadState gamePadState = null;
	/** ÕQ[pbh̏. */
	private GamePadState prevGamePadState = null;
	/** ݂̃L[{[h̏. */
	private KeyState keyState = null;
	/** ÕL[{[h̏. */
	private KeyState prevKeyState = null;
	/** ݂̃}EX̏. */
	private MouseState mouseState = null;
	/** Õ}EX̏. */
	private MouseState prevMouseState = null;
	//
	/** B̃CX^Xł. */
	private static final InputState INSTANCE = new InputState();

	/**
	 * VOgNXł.
	 * getInstancegpĂB<br>
	 */
	private InputState() {
		if (PlayerConstants.getInstance().isUsingGamepad()) {
			gamePadState = GamePadConnection.createClearState();
		}
		if (PlayerConstants.getInstance().isUsingKeyboard()) {
			keyState = KeyConnection.createClearState();
		}
		if (PlayerConstants.getInstance().isUsingMouse()) {
			mouseState = MouseConnection.createClearState();
		}
	}

	/**
	 * CX^X擾܂.
	 * ̃\bhĂяoƁA݂̓͏Ԃ܂B<br>
	 * @return InputStatẽCX^XԂ܂B<br>
	 */
	public static InputState getInstance() {
		INSTANCE.refresh();
		return INSTANCE;
	}

	/**
	 * ͏ԂXV܂.
	 */
	private void refresh() {
		if (PlayerConstants.getInstance().isUsingGamepad()) {
			prevGamePadState = gamePadState;
			gamePadState = GamePadConnection.getState(0);
		}
		if (PlayerConstants.getInstance().isUsingMouse()) {
			prevMouseState = mouseState;
			mouseState = MouseConnection.getState();
		}
		if (PlayerConstants.getInstance().isUsingKeyboard()) {
			prevKeyState = keyState;
			keyState = KeyConnection.getState();
		}
	}

	@Override
	public boolean isAnyInput() {
		boolean result = false;
		if (PlayerConstants.getInstance().isUsingGamepad()) {
			result |= gamePadState.isAnyInput();
		}
		if (PlayerConstants.getInstance().isUsingMouse()) {
			result |= mouseState.isAnyInput();
		}
		return result | keyState.isAnyInput();
	}

	@Override
	public boolean isAnyButtonInput() {
		boolean result = false;
		if (PlayerConstants.getInstance().isUsingGamepad()) {
			result |= gamePadState.isAnyButtonInput();
		}
		if (PlayerConstants.getInstance().isUsingMouse()) {
			result |= mouseState.isAnyButtonInput();
		}
		return result | keyState.isAnyButtonInput();
	}

	@Override
	public boolean isEmptyInput() {
		boolean result = true;
		if (PlayerConstants.getInstance().isUsingGamepad()) {
			result &= gamePadState.isEmptyInput();
		}
		if (PlayerConstants.getInstance().isUsingMouse()) {
			result &= mouseState.isEmptyInput();
		}
		return result & keyState.isEmptyInput();
	}

	/**
	 * L[{[h̃L[Ă邩܂.
	 * @param key 肷L[w肵܂B<br>
	 * @param type O̓͏Ԃ邩肵܂B<br>
	 * @return w肳ꂽL[݉ĂꍇAtrueԂ܂B<br>
	 */
	public boolean isPressed(Keys key, InputType type) {
		return type == InputType.CONTINUE
				? keyState.isPressed(key)
				: keyState.isPressed(key) && !prevKeyState.isPressed(key);
	}

	/**
	 * Q[pbh̃{^Ă邩܂.
	 * @param button 肷{^w肵܂B<br>
	 * @param type O̓͏Ԃ邩肵܂B<br>
	 * @return w肳ꂽ{^݉ĂꍇAtrueԂ܂B<br>
	 */
	public boolean isPressed(GamePadButtons button, InputType type) {
		return type == InputType.CONTINUE
				? gamePadState.buttons.isPressed(button)
				: gamePadState.buttons.isPressed(button) && !prevGamePadState.buttons.isPressed(button);
	}

	/**
	 * }EX̃{^Ă邩܂.
	 * @param button 肷{^w肵܂B<br>
	 * @param type O̓͏Ԃ邩肵܂B<br>
	 * @return w肳ꂽ{^݉ĂꍇAtrueԂ܂B<br>
	 */
	public boolean isPressed(MouseButtons button, InputType type) {
		if (!PlayerConstants.getInstance().isUsingMouse()) {
			return false;
		}
		return type == InputType.CONTINUE
				? mouseState.isPressed(button)
				: mouseState.isPressed(button) && !prevMouseState.isPressed(button);
	}

	/**
	 * Q[pbh̍XeBbNAw肳ꂽɓ|Ă邩܂.
	 * @param absBorderLine ̊ƂȂ銄łBʏ0f1.0f𑗐M܂B<br>
	 * @param dir 肷łB<br>
	 * @param type O̓͏Ԃ邩肵܂B<br>
	 * @return w肳ꂽɁAabsBorderLine*100%ȏ|ĂꍇtrueԂ܂B<br>
	 */
	public boolean leftStickOperation(float absBorderLine, FourDirection dir, InputType type) {
		switch (dir) {
			case EAST: {
				switch (type) {
					case SINGLE: {
						return gamePadState.leftStick.getX() < -Math.abs(absBorderLine)
								&& prevGamePadState.leftStick.getX() >= -Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.leftStick.getX() < -Math.abs(absBorderLine)
								&& gamePadState.leftStick.getX() < 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}
			}
			case WEST: {
				switch (type) {
					case SINGLE: {
						return Math.abs(gamePadState.leftStick.getX()) > Math.abs(absBorderLine)
								&& prevGamePadState.leftStick.getX() <= Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.leftStick.getX() > Math.abs(absBorderLine)
								&& gamePadState.leftStick.getX() > 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}
			}
			case NORTH: {
				switch (type) {
					case SINGLE: {
						return gamePadState.leftStick.getY() > Math.abs(absBorderLine)
								&& prevGamePadState.leftStick.getY() <= Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.leftStick.getY() > Math.abs(absBorderLine)
								&& gamePadState.leftStick.getY() > 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}
			}
			case SOUTH: {
				switch (type) {
					case SINGLE: {
						return gamePadState.leftStick.getY() < -Math.abs(absBorderLine)
								&& prevGamePadState.leftStick.getY() >= -Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.leftStick.getY() < -Math.abs(absBorderLine)
								&& gamePadState.leftStick.getY() < 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}

			}
			default: {
				throw new AssertionError("unuse default : dir=[" + dir + "]");
			}
		}
	}

	/**
	 * Q[pbh̉EXeBbNAw肳ꂽɓ|Ă邩܂.
	 * @param absBorderLine ̊ƂȂ銄łBʏ0f1.0f𑗐M܂B<br>
	 * @param dir 肷łB<br>
	 * @param type O̓͏Ԃ邩肵܂B<br>
	 * @return w肳ꂽɁAabsBorderLine*100%ȏ|ĂꍇtrueԂ܂B<br>
	 */
	public boolean rightStickOperation(float absBorderLine, FourDirection dir, InputType type) {
		switch (dir) {
			case EAST: {
				switch (type) {
					case SINGLE: {
						return gamePadState.rightStick.getX() < -Math.abs(absBorderLine)
								&& prevGamePadState.rightStick.getX() >= -Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.rightStick.getX() < -Math.abs(absBorderLine)
								&& gamePadState.rightStick.getX() < 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}
			}
			case WEST: {
				switch (type) {
					case SINGLE: {
						return gamePadState.rightStick.getX() > Math.abs(absBorderLine)
								&& prevGamePadState.rightStick.getX() <= Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.rightStick.getX() > Math.abs(absBorderLine)
								&& gamePadState.rightStick.getX() > 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}
			}
			case NORTH: {
				switch (type) {
					case SINGLE: {
						return gamePadState.rightStick.getY() > Math.abs(absBorderLine)
								&& prevGamePadState.rightStick.getY() <= Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.rightStick.getY() > Math.abs(absBorderLine)
								&& gamePadState.rightStick.getY() > 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}
			}
			case SOUTH: {
				switch (type) {
					case SINGLE: {
						return gamePadState.rightStick.getY() < -Math.abs(absBorderLine)
								&& prevGamePadState.rightStick.getY() >= -Math.abs(absBorderLine);
					}
					case CONTINUE: {
						return gamePadState.rightStick.getY() < -Math.abs(absBorderLine)
								&& gamePadState.rightStick.getY() > 0;
					}
					default: {
						throw new AssertionError("unuse default : type=[" + type + "]");
					}
				}

			}
			default: {
				throw new AssertionError("! > InputState rightStickOperation : unuse default : dir=[" + dir + "]");
			}
		}
	}

	/**
	 * ݂̃Q[pbh̏Ԃ擾܂.
	 * Q[pbhgpłȂꍇAnullԂ܂B<br>
	 * @return Q[pbh̏ԂԂ܂B<br>
	 */
	public GamePadState getGamePadState() {
		return gamePadState;
	}

	/**
	 * ÕQ[pbh̏Ԃ擾܂.
	 * Q[pbhgpłȂꍇAnullԂ܂B<br>
	 * @return Q[pbh̏ԂԂ܂B<br>
	 */
	public GamePadState getPrevGamePadState() {
		return prevGamePadState;
	}

	/**
	 * ݂̃L[{[h̏Ԃ擾܂.
	 * L[{[hgpłȂꍇAnullԂ܂B<br>
	 * @return L[{[h̏ԂԂ܂B<br>
	 */
	public KeyState getKeyState() {
		return keyState;
	}

	/**
	 * ÕL[{[h̏Ԃ擾܂.
	 * L[{[hgpłȂꍇAnullԂ܂B<br>
	 * @return L[{[h̏ԂԂ܂B<br>
	 */
	public KeyState getPrevKeyState() {
		return prevKeyState;
	}

	/**
	 * ݂̃}EX̏Ԃ擾܂.
	 * }EXgpłȂꍇAnullԂ܂B<br>
	 * @return }EX̏ԂԂ܂B<br>
	 */
	public MouseState getPrevMouseState() {
		return prevMouseState;

	}

	/**
	 * Õ}EX̏Ԃ擾܂.
	 * }EXgpłȂꍇAnullԂ܂B<br>
	 * @return }EX̏ԂԂ܂B<br>
	 */
	public MouseState getMouseState() {
		return mouseState;
	}

	@Override
	public InputState clone() {
		InputState result = (InputState) super.clone();

		if (this.gamePadState != null) {
			result.gamePadState = this.gamePadState.clone();
		}
		if (this.prevGamePadState != null) {
			result.prevGamePadState = this.prevGamePadState.clone();
		}
		if (this.mouseState != null) {
			result.mouseState = this.mouseState.clone();
		}
		if (this.prevMouseState != null) {
			result.prevMouseState = this.prevMouseState.clone();
		}
		if (this.keyState != null) {
			result.keyState = this.keyState.clone();
		}
		if (this.prevKeyState != null) {
			result.prevKeyState = this.prevKeyState.clone();
		}
		return result;
	}

	@Override
	public String toString() {
		return "InputState{" + "gamePadState=" + gamePadState + ", keyState=" + keyState + ", mouseState=" + mouseState + '}';
	}
}
