/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.inputDevice;

import java.util.BitSet;

/**
 * Kinugasa : KeyState : L[͂̏Ԃi[܂.
 * <br>
 * L[̏ԂBitSetNXgpĊi[܂B<br>
 * L[̏ԂɃANZX邽߂̃CfbNXAWTL[R[h܂
 * bvKeys񋓂gp܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_13:16:01<br>
 * @author Dra0211<br>
 */
public class KeyState extends InputDeviceState {

	private static final long serialVersionUID = -2099383783403705414L;
	/** L[̏Ԃi[z. */
	private BitSet keySet;

	/**
	 * pbP[WANZX.
	 *
	 * @param state L[̏.fB[vRs[쐬.<br>
	 */
	KeyState(BitSet state) {
		this.keySet = (BitSet) state.clone();
	}

	/**
	 * L[̏Ԃ擾܂.
	 * 1񂾂̔́uǑԁvێĂƂŎ\ł.<br>
	 *
	 * @param k L[.<br>
	 *
	 * @return ĂƂTRUEԂ.<br>
	 */
	public boolean isPressed(Keys k) {
		return keySet.get(k.getKeyCode());
	}

	/**
	 * L[̏Ԃ擾܂.
	 * ̃\bh́AisPressed(Keys)ɓ삷邱Ƃ܂.<br>
	 *
	 * @param index L[̃CfbNXBKeyEventNX̒萔gpĂB<br>
	 *
	 * @return ĂƂTRUEԂ.<br>
	 */
	public boolean isPressed(int index) {
		return keySet.size() <= index ? false : keySet.get(index);
	}

	@Override
	public String toString() {
		return "KeyState{" + "keySet=" + keySet + '}';
	}

	@Override
	public KeyState clone() {
		KeyState result = (KeyState) super.clone();
		result.keySet = (BitSet) this.keySet.clone();
		return result;
	}

	@Override
	public boolean isAnyInput() {
		return !keySet.isEmpty();
	}

	@Override
	public boolean isAnyButtonInput() {
		return !keySet.isEmpty();
	}

	@Override
	public boolean isEmptyInput() {
		return keySet.isEmpty();
	}
}
