/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.inputDevice;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

/**
 * Kinugasa : MouseConnection : }EXJ[\̈ʒu͏Ԃ邽߂̃}EXA_v^̎ł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_14:09:50<br>
 * @author Dra0211<br>
 */
public class MouseConnection extends MouseAdapter {

	/** B̃CX^Xł. */
	private static final MouseConnection INSTANCE = new MouseConnection();
	/** ͂ĂȂԂMouseStateł. */
	private static final MouseState CLEAR_STATE = new MouseState(false, false, false, false, false, 0, new Point(), new Point());

	/**
	 * R|[lgɂ̃Xiǉ܂.
	 *
	 * @param component Xio^R|[lg𑗐M܂B<br>
	 */
	public static void setListener(Component component) {
		component.addMouseListener(INSTANCE);
		component.addMouseMotionListener(INSTANCE);
		component.addMouseWheelListener(INSTANCE);
	}

	/**
	 * ̃}EXXe[g𔭍s܂.
	 * ̃\bh͏ɓCX^XԂ܂B<br>
	 *
	 * @return ̃}EXXe[gԂ܂BĂȂԂłBW0,0łB<br>
	 */
	public static MouseState createClearState() {
		return CLEAR_STATE;
	}

	/**
	 * VOgNXł.
	 */
	private MouseConnection() {
		location = new Point();
		locationOnScreen = new Point();
	}

	/**
	 * ݂̃}EX̏Ԃ擾܂.
	 * @return }EX̓͏ԂԂ܂B<br>
	 */
	public static MouseState getState() {
		return new MouseState(
				INSTANCE.buttonState[MouseEvent.BUTTON1 - 1],
				INSTANCE.buttonState[MouseEvent.BUTTON3 - 1],
				INSTANCE.buttonState[MouseEvent.BUTTON2 - 1],
				INSTANCE.entry,
				INSTANCE.drag,
				INSTANCE.wheelValue,
				INSTANCE.location,
				INSTANCE.locationOnScreen);
	}
	/** }EX̃{^̓͏Ԃł. */
	private boolean[] buttonState = {false, false, false};
	/** }EXEChEɂ邩𔻒肵܂. */
	private boolean entry;
	/** hbOł邩𔻒肵܂. */
	private boolean drag;
	/** EChEɂ}EXJ[\̈ʒuł. */
	private Point location;
	/** XN[ɂ}EXJ[\̈ʒuł. */
	private Point locationOnScreen;
	/** zC[̉]ʂł.
	 * ɉ񂷂ƕƂȂ܂B */
	private int wheelValue;

	/**
	 * }EXA_v^̎ł.
	 * @param e CxgM܂B<br>
	 */
	@Override
	public void mouseDragged(MouseEvent e) {
		drag = true;
	}

	/**
	 * }EXA_v^̎ł.
	 * @param e CxgM܂B<br>
	 */
	@Override
	public void mouseMoved(MouseEvent e) {
		location = e.getPoint();
		locationOnScreen = e.getLocationOnScreen();
	}

	/**
	 * }EXA_v^̎ł.
	 * @param e CxgM܂B<br>
	 */
	@Override
	public void mousePressed(MouseEvent e) {
		buttonState[e.getButton() - 1] = true;
	}

	/**
	 * }EXA_v^̎ł.
	 * @param e CxgM܂B<br>
	 */
	@Override
	public void mouseReleased(MouseEvent e) {
		buttonState[e.getButton() - 1] = false;
		drag = false;
	}

	/**
	 * }EXA_v^̎ł.
	 * @param e CxgM܂B<br>
	 */
	@Override
	public void mouseEntered(MouseEvent e) {
		entry = true;
	}

	/**
	 * }EXA_v^̎ł.
	 * @param e CxgM܂B<br>
	 */
	@Override
	public void mouseExited(MouseEvent e) {
		entry = false;
	}

	/**
	 * }EXA_v^̎ł.
	 * @param e CxgM܂B<br>
	 */
	@Override
	public void mouseWheelMoved(MouseWheelEvent e) {
		wheelValue = e.getUnitsToScroll();
	}
}
