/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.SerializableImage;

/**
 * Kinugasa : ImageSprite : P̉摜\{XvCg̎ł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_20:21:03<br>
 * @author Dra0211<br>
 */
public class ImageSprite extends BasicSprite {

	private static final long serialVersionUID = 2943439927664974228L;
	private SerializableImage image;
	private ImagePainter drawingModel;

	/**
	 * V摜XvCg쐬܂.
	 * ̃RXgN^ł́A摜nullɁA
	 * `惂fIMAGE_BOUNDS_XYɐݒ肳܂B<br>
	 */
	public ImageSprite() {
		super();
		this.image = null;
		this.drawingModel = ImagePainterStorage.IMAGE_BOUNDS_XY;
	}

	/**
	 * V摜XvCg쐬܂.
	 * ̃RXgN^ł́A摜nullɁA
	 * `惂fIMAGE_BOUNDS_XYɐݒ肳܂B<br>
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 */
	public ImageSprite(float x, float y, float w, float h) {
		super(x, y, w, h);
		this.image = null;
		this.drawingModel = ImagePainterStorage.IMAGE_BOUNDS_XY;
	}

	/**
	 * V摜XvCg쐬܂.
	 * ̃RXgN^ł́A
	 * `惂fIMAGE_BOUNDS_XYɐݒ肳܂B<br>
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param image \摜w肵܂B<br>
	 */
	public ImageSprite(float x, float y, float w, float h, SerializableImage image) {
		super(x, y, w, h);
		this.image = image;
		this.drawingModel = ImagePainterStorage.IMAGE_BOUNDS_XY;
	}

	/**
	 * V摜XvCg쐬܂.
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param image \摜w肵܂B<br>
	 * @param model `@w肵܂B<br>
	 */
	public ImageSprite(float x, float y, float w, float h, SerializableImage image, ImagePainter model) {
		super(x, y, w, h);
		this.image = image;
		this.drawingModel = model;
	}

	/**
	 * V摜XvCg쐬܂.
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param vector ړxNgw肵܂B<br>
	 * @param mm ړfw肵܂B<br>
	 * @param image \摜w肵܂B<br>
	 * @param dm `惂fw肵܂B<br>
	 */
	public ImageSprite(float x, float y, float w, float h, VectorF vector,
			MovingModel mm, SerializableImage image, ImagePainter dm) {
		super(x, y, w, h, vector, mm);
		this.image = image;
		this.drawingModel = dm;
	}

	/**
	 * V摜XvCg쐬܂.
	 * ̃RXgN^̓N[jOp̃}X^f[^쐬ꍇɗLpłB<br>
	 *
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param vector ړxNgw肵܂B<br>
	 * @param mm ړfw肵܂B<br>
	 * @param image \摜w肵܂B<br>
	 * @param dm `惂fw肵܂B<br>
	 */
	public ImageSprite(float w, float h, VectorF vector,
			MovingModel mm, SerializableImage image, ImagePainter dm) {
		super(w, h, vector, mm);
		this.image = image;
		this.drawingModel = dm;
	}

	@Override
	public void draw(Graphics2D g) {
		if (!isVisible() || !isExist()) {
			return;
		}
		if (image == null) {
			return;
		}
		drawingModel.draw(g, this);
	}

	public BufferedImage getImage() {
		return image.get();
	}

	public SerializableImage getSerializableImage() {
		return image;
	}

	/**
	 * 摜̕擾܂.
	 * 摜̃TCY͉摜CX^Xɐݒ肳ĂAsNZPʂ̃TCYłB<br>
	 * ̒l͕`惂fɂĂ͖Aۂ̃XvCg̃TCYƂ͈Ⴄꍇ܂B<br>
	 *
	 * @return 摜̕Ԃ܂B<br>
	 */
	public int getImageWidth() {
		return image.getWidth();
	}

	/**
	 * 摜̍擾܂.
	 * 摜̃TCY͉摜CX^Xɐݒ肳ĂAsNZPʂ̃TCYłB<br>
	 * ̒l͕`惂fɂĂ͖Aۂ̃XvCg̃TCYƂ͈Ⴄꍇ܂B<br>
	 *
	 * @return 摜̍Ԃ܂B<br>
	 */
	public int getImageHeight() {
		return image.getHeight();
	}

	/**
	 * XvCgɕ\摜ݒ肵܂.
	 *
	 * @param image
	 */
	public void setImage(BufferedImage image) {
		this.image = new SerializableImage(image);
	}

	public void setImage(SerializableImage image) {
		this.image = image;
	}

	/**
	 * `惂f擾܂.
	 *
	 * @return ݒ蒆̕`惂fԂ܂B<br>
	 */
	public ImagePainter getDrawingModel() {
		return drawingModel;
	}

	/**
	 * `惂fݒ肵܂.
	 *
	 * @param drawingModel ݒ肷`惂fB<br>
	 */
	public void setDrawingModel(ImagePainter drawingModel) {
		this.drawingModel = drawingModel;
	}

	//DrawingModel̃N[͎łȂ
	@Override
	public ImageSprite clone() {
		ImageSprite sprite = (ImageSprite) super.clone();
		//sprite.drawingModel = this.drawingModel.clone();
		return sprite;
	}

	@Override
	public String toString() {
		return "ImageSprite location=[" + getX() + "," + getY() + "] size=["
				+ getWidth() + "," + getHeight() + "] " + "center=["
				+ getCenterX() + "," + getCenterY() + "] personalCenter=["
				+ getPersonalCenterX() + "," + getPersonalCenterY() + "] visible=["
				+ isVisible() + "] exist=[" + isExist() + "] speed=[" + getSpeed() + "] vector=["
				+ getVector() + "] z=[" + getZ() + "] image=[" + getImage() + "] drawingModel=["
				+ getDrawingModel().getName() + "]";
	}
}
