/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object.movingModel;

import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;

/**
 * Kinugasa : SpeedChange : .
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_18:29:00<br>
 * @author Dra0211<br>
 */
public class SpeedChange extends MovingModel {

	private static final long serialVersionUID = 1877081814619883037L;
	/** ̈ړŉZl. */
	private float addSpeed;
	/** x̍Œli܂). */
	private float minSpeed;
	/** x̍ől(܂). */
	private float maxSpeed;

	/**
	 * ړxύXړf\z܂.
	 * 
	 * @param addSpeed P̈ړŉZ鑬x̒l.wł.<Br>
	 * @param min      Œ̑x.̒l܂.<br>
	 * @param max      ő̑x.̒l܂.<br>
	 *
	 * @throws IllegalArgumentException min>max̂Ƃɓ.<br>
	 */
	public SpeedChange(float addSpeed, float min, float max) throws IllegalArgumentException {
		super();
		if (min > max) {
			throw new IllegalArgumentException("! > min > max ! min=[" + min + "] max=[" + max + "]");
		}
		this.addSpeed = addSpeed;
		this.minSpeed = min;
		this.maxSpeed = max;
	}

	/**
	 * ړxύXړf\z܂.
	 * Œᑬxэő呬xgp܂.(ݒ)<br>
	 * 
	 * @param addSpeed P̈ړŉZ鑬x̒l.wł.<Br>
	 */
	public SpeedChange(float addSpeed) {
		this(addSpeed, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
	}

	/**
	 * ړ̓xɉZl擾܂.
	 * 
	 * @return Zl.<bR>
	 */
	public float getAddSpeed() {
		return addSpeed;
	}

	/**
	 * ő̑x擾܂.
	 * 
	 * @return ő呬x.<bR>
	 */
	public float getMaxSpeed() {
		return maxSpeed;
	}

	/**
	 * Œ̑x擾܂.
	 * 
	 * @return Œ̑x.<bR>
	 */
	public float getMinSpeed() {
		return minSpeed;
	}

	/**
	 * ړ̓xɉZlݒ肵܂.
	 * 
	 * @param addSpeed Zl.<bR>
	 */
	public void setAddSpeed(float addSpeed) {
		this.addSpeed = addSpeed;
	}

	/**
	 * ő̑xݒ肵܂.
	 * 
	 * @param maxSpeed ő呬x.<bR>
	 */
	public void setMaxSpeed(float maxSpeed) {
		this.maxSpeed = maxSpeed;
	}

	/**
	 * Œ̑xݒ肵܂.
	 * 
	 * @param minSpeed Œ̑x.<bR>
	 */
	public void setMinSpeed(float minSpeed) {
		this.minSpeed = minSpeed;
	}

	@Override
	public void move(BasicSprite s) {
		s.setSpeed(s.getSpeed() + addSpeed);
		if (s.getSpeed() < minSpeed) {
			s.setSpeed(minSpeed);
		}
		if (s.getSpeed() > maxSpeed) {
			s.setSpeed(maxSpeed);
		}
	}

	@Override
	public SpeedChange clone() {
		return (SpeedChange) super.clone();
	}
}
