/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.io.Serializable;
import kinugasa.contents.resource.Nameable;

/**
 * Kinugasa : CharSet : ̓EChEœ͉\ȕ̃ZbgƑ܂ȕ`ʒu`NXł.
 * <br>
 * Zbg͈̕1邱ƂőI\ȕ̃Zbg`NXłB<br>
 * A1̕ZbgɊ܂܂镶͏de܂B<br>
 * ZbgɎgp镶͂̕`ʒuw肷邽߂ɉs"\n"уXy[X" "gpł܂B<br>
 * s
 * <br>
 *
 * @version 1.0.0 - 2012/11/24_17:23:37.<br>
 * @author Dra0211<br>
 * <br>
 */
public final class CharSet implements Nameable, Serializable {

	private static final long serialVersionUID = -6702495690225290022L;
	/** ̕Zbg̖Oł. */
	private String name;
	/** ̕Zbggp邷ׂĂ̕ł. */
	private String values;
	/** Zbg̕`TCỸtHgTCYɑ΂Wł. */
	private float drawSizeMag;

	/**
	 * VZbg`܂.
	 * ZbgO[oɈ悤ɂɂ
	 * CharSetHostɒǉKv܂B<br>
	 *
	 * @param name     ̕Zbg̖Ow肵܂B<br>
	 * @param charSize ̕`TCY␳WłB
	 *                    Zbg̓̕tHgTCY*charSize̕u̕vƂĈ܂B<br>
	 * @param allData  f[^𑗐M܂BXy[X" "s"\n"gpł܂B<br>
	 *
	 * @throws IllegalArgumentException f[^ɑSp̃A_[XRA"Q"܂܂Ăꍇɓ܂B
	 *                                     "Q"͖̓f[^߂Ɏgp邽߁AZbgƂĂ͎gpł܂B<br>
	 */
	public CharSet(String name, float charSize, String allData) throws IllegalArgumentException {
		if (allData.contains("Q")) {
			throw new IllegalArgumentException("! > CharSet : ctor : cant use \"Q\" : name=["
					+ name + "] bytes=[" + charSize + "] data=[" + allData + "]");
		}
		this.name = name;
		this.drawSizeMag = charSize;
		this.values = allData;
	}

	/**
	 * c̕ZbgɊ܂܂Ă邩܂.
	 *
	 * @param c 镶𑗐M܂B<br>
	 *
	 * @return c̕ZbgɊ܂܂ĂꍇtrueԂ܂B<br>
	 */
	public boolean contains(String c) {
		return values.contains(c);
	}

	/**
	 * c̕ZbgɊ܂܂Ă邩܂.
	 *
	 * @param c 镶𑗐M܂B<br>
	 *
	 * @return c̕ZbgɊ܂܂ĂꍇtrueԂ܂B<br>
	 */
	public boolean cotnains(char c) {
		return values.contains(Character.toString(c));
	}

	/**
	 * ̕Zbg̃tHgTCYɓKp␳l擾܂.
	 *
	 * @return tHgTCYɓKp␳lԂ܂B<br>
	 */
	public float getDrawSizeMag() {
		return drawSizeMag;
	}

	/**
	 * tHgTCY␳A̕ZbgɊ܂܂镶̓̓K؂ȃTCYԂ܂.
	 *
	 * @param fontSize ␳tHgTCY𑗐M܂B<br>
	 *
	 * @return fontSIze * getDrawSizeMag()Ԃ܂B<br>
	 */
	public float convertSize(float fontSize) {
		return fontSize * drawSizeMag;
	}

	/**
	 * ̕ZbgŎgp邷ׂĂ̕܂܂ꂽԂ܂.
	 *
	 * @return RXgN^Ŏw肳ꂽgp镶Ԃ܂B<br>
	 */
	public String getValues() {
		return values;
	}

	/**
	 * Zbg̕𕪉A1ƂɃeLXgxɔs܂.
	 *
	 * @param startX     ł̃xzuXWw肵܂B<br>
	 * @param startY     ł̃xzuYWw肵܂B<br>
	 * @param labelModel gp郉xfw肵܂BN[܂B<br>
	 *
	 * @return w肵ō쐬̕Zbg̕\px2ɔzuĕԂ܂B<br>
	 */
	public TextLabel[][] parse(float startX, float startY, LabelModel labelModel) {
		TextLabel[][] result = new TextLabel[rowNum()][];
		float charSize = labelModel.getFontSize() + 2;
		String[] lines = values.split("\n");
		for (int yIdx = 0; yIdx < lines.length; yIdx++) {
			char[] lineData = lines[yIdx].toCharArray();
			result[yIdx] = new TextLabel[lineData.length];
			for (int xIdx = 0; xIdx < lineData.length; xIdx++) {
				result[yIdx][xIdx] = new TextLabel(
						startX + xIdx * charSize,
						startY + yIdx * charSize,
						Character.toString(lineData[xIdx]), labelModel);
			}
		}
		return result;
	}

	/**
	 * ̕Zbg̍sԂ܂.
	 *
	 * @return ̕Zbg\zۂ̍sԂ܂B<br>
	 */
	public int rowNum() {
		return values.split("\n").length;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		return "CharSet{" + "name=" + name + ", values=" + values + '}';
	}
}
