/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.util.ArrayList;
import java.util.List;
import kinugasa.contents.resource.Storage;

/**
 * Kinugasa : CharSetStorage : Zbg̃LbVf[^т̃vZbgۊǂXg[Wł.
 * <br>
 *
 * <br>
 *
 * @author dra0211 ( <a href="mailto:d0211@live.jp">d0211@live.jp</a>&nbsp;).<br>
 * @author Dra0211<br>
 * <br>
 */
public class CharSetStorage extends Storage<CharSet> {

	/** ̕Zbg͔p̃At@xbg񋟂܂.
	 * At@xbgaz7Xy[Xŋ؂Ă܂B<br>
	 */
	public static final CharSet A_TO_Z_LOW = new CharSet("A_TO_Z_LOW", 1.6f,
			"abcdefg hijklmn opqrstu vwxyz");
	/** ̕Zbg͔p啶̃At@xbg񋟂܂.
	 * At@xbgAX7Xy[Xŋ؂Ă܂B<br>
	 */
	public static final CharSet A_TO_Z_UP = new CharSet("A_TO_Z_UP", 1.6f,
			"ABCDEFG HIJKLMN OPQRSTU VWXYZ");
	/** ̕Zbg͔p09܂ł̐񋟂܂.
	 * 0...9̏ԂłB<br>
	 */
	public static final CharSet NUMBER = new CharSet("NUMBER", 1.6f,
			"0123456789                   ");
	/** ̕Zbg͑Sp09܂ł̐񋟂܂.
	 * 0...9̏ԂłB<br>
	 */
	public static final CharSet DOUBLE_BYTE_NUMBER = new CharSet("DOUBLE_BYTE_NUMBER", 1.0f,
			"OPQRSTUVWX                   ");
	/** ̕Zbg͔p09܂ł̐eL[̔zuŒ񋟂܂.
	 * 789 - 456 - 123 - 0̏ԂłB<br>
	 */
	public static final CharSet TEN_KEY = new CharSet("TEN_KEY", 1.6f,
			"789\n456\n123\n0");
	/** ̕Zbg͑Sp09܂ł̐eL[̔zuŒ񋟂܂.
	 * 789 - 456 - 123 - 0̏ԂłB<br>
	 */
	public static final CharSet DOUBLE_BYTE_TEN_KEY = new CharSet("DOUBLE_BYTE_TEN_KEY", 1.0f,
			"VWX\nSTU\nPQR\nO");
	/** ̕Zbg͑SĂ̂Ђ炪Ȃ񋟂܂. */
	public static final CharSet HIRAGANA = new CharSet("HIRAGANA", 1.0f,
			"@@@ĂƁ@Ȃɂʂ˂\n"
			+ "͂Ђӂւف@܂݂ނ߂@@@@@@@\n"
			+ "@@@@[AB@@@@@@@@@@@@\n"
			+ "@@Âłǁ@΂тԂׂځ@ς҂Ղ؂");
	/** ̕Zbgׂ͂Ă̑Sp̃J^Ji񋟂܂. */
	public static final CharSet KATAKANA = new CharSet("KATAKANA", 1.0f,
			"ACEGI@JLNPR@TVXZ\@^`ceg@ijklm\n"
			+ "nqtwz@}~@@@@@\n"
			+ "@BDFH@b@@@@[AB@@@@@@@@@@\n"
			+ "KMOQS@UWY[]@_adfh@orux{@psvy|");
	/** ̕Zbg͔p̐}`ыL񋟂܂. */
	public static final CharSet SIGN = new CharSet("BYTE_SIGN", 1.6f,
			" !\"#$%&'() *+,-./:;    \n"
			+ "<=>?@[\\] ^_`{|}~");
	/** ̕Zbg͑SpŗL̐}`ыL񋟂܂. */
	public static final CharSet DOUBLE_BYTE_SIGN = new CharSet("DOUBLE_BYTE_SIGN", 1.0f,
			"~E@@");
	private static final long serialVersionUID = -1069168298749770811L;

	/**
	 * VOgNXł.
	 */
	private CharSetStorage() {
		super();
		add(A_TO_Z_LOW);
		add(A_TO_Z_UP);
		add(HIRAGANA);
		add(KATAKANA);
		add(NUMBER);
		add(DOUBLE_BYTE_NUMBER);
		add(SIGN);
		add(DOUBLE_BYTE_SIGN);
		add(TEN_KEY);
		add(DOUBLE_BYTE_TEN_KEY);
	}
	/** ̃NX̗B̃CX^Xł. */
	private static final CharSetStorage INSTANCE = new CharSetStorage();

	/**
	 * CX^X擾܂.
	 *
	 * @return ̃NX̗B̃CX^XԂ܂B<br>
	 */
	public static CharSetStorage getInstance() {
		return INSTANCE;
	}

	/**
	 * c܂܂Ă镶ZbgAׂĎ擾܂.
	 *
	 * @param c 镶w肵܂B<br>
	 *
	 * @return ܂܂镶ZbgXgƂĕԂ܂BȂꍇ͋̃XgԂ܂B<br>
	 */
	public List<CharSet> containsChar(char c) {
		return containsChar(Character.toString(c));
	}

	/**
	 * c܂܂Ă镶ZbgAׂĎ擾܂.
	 *
	 * @param str 镶w肵܂B<br>
	 *
	 * @return ܂܂镶ZbgXgƂĕԂ܂BȂꍇ͋̃XgԂ܂B<br>
	 */
	public List<CharSet> containsChar(String str) {
		List<CharSet> result = new ArrayList<CharSet>(8);
		for (CharSet charSet : getAll()) {
			if (charSet.contains(str)) {
				result.add(charSet);
			}
		}
		return result;
	}
}
